@extends('layouts.Admin.adminForm')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>

    <!-- Main content -->
    <section class="content main_box">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <div class="box box-primary">
                    {{ Form::model($userDetail, array('route' => array($controllerUri.'.update', \Crypt::encryptString($userDetail->id)), 'method' => 'PUT', 'novalidate' => 'false', 'id'=>$formId)) }}

                    <div class="box-body form_box">
                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">{{ $userDetail->name }}({{$userDetail->symbal}})</label>
                                    {{ Form::text('delivery_charge', $userDetail->value, ['class'=>'form-control required', 'id'=>'delivery_charge','placeholder' => $userDetail->name, 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Status</label>
                                    {{Form::select('status',[1 => 'Active', 0 => 'Inactive'], ((isset($userDetail->status) && is_numeric($userDetail->status)) ? $userDetail->status : 0), ['class'=>'form-control'])}}
                                </div>
                            </div>
                        </div>

                        <div class="box-footer row">
                            <div class="col-md-6">
                                <div class="form-group" style="text-align: center">
                                    <span>
                                    {{ Form::submit('Submit', array('class'=>'btn btn-success')) }}
                                    </span>
                                    <span style="margin-left: 10px">
                                        <a href="{{route('delivery-charge-setting.index')}}">
                                            <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>

                    {{Form::close()}}
                </div>
            </div>
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
@endsection
