@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get', 'class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'Email / Name / Phone number', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-2">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{$url}}" class="btn btn-default">Reset</a>
                                </div>


                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>

                    <div class="box-body">
                        @if(count($userList) > 0)
                        <div class="adminusers_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="5%">Sr.No.</th>
                                        <th width="15%">@sortablelink('first_name', 'First Name')</th>
                                        <th width="15%">@sortablelink('last_name', 'Last Name')</th>
                                        <th width="15%">@sortablelink('email')</th>
                                        <th width="15%">Image</th>
                                        <th width="15%">Phone Number</th>
                                        <th width="15%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $srNo = 1;
                                    @endphp
                                    @foreach($userList as $user)

                                    <tr>
                                        <td>{{ $srNo++ }}</td>
                                         <td>
                                            <a href="{{url($url.'/'.\Crypt::encryptString($user->id))}}" class="various"
                                                data-fancybox-type="iframe" title="View">{{ $user->first_name }}</a>
                                            </td>
                                        
                                        <td>{{ !empty($user->last_name) ? $user->last_name : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                        <td>{{ !empty($user->email) ? $user->email : \config('admin.constants.EmptyNotation') }}</td>
                                         <td>
                                            
                                            @if(!empty($user->profile_image))
                                            <div class="ImgPopup productimages" style="cursor: pointer"
                                                href="{{$user->profile_image}}">
                                                {{ Html::image($user->profile_image, '', array('width' => 50,'height' => 50, 'title' => 'Profile Image')) }}
                                            </div>
                                            @else
                                            <div class="ImgPopup productimages" style="cursor: pointer"
                                            href="{{ $defaultAvatarUrl }}">
                                            {{ Html::image($defaultAvatarUrl, '', array('width' => 50,'height' => 50, 'title' => 'Profile Image')) }}
                                        </div>
                                            @endif
                                        </td>
                                        <td>{{ !empty($user->phone_number) ? $user->phone_number : \config('admin.constants.EmptyNotation') }}</td>

                                        
                                        <td class="action-btn-permission">

                                            @include('elements.Admin.actions-link', ['row' => $user])
                                        </td>
                                     
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    @if(count($userList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $userList])
                    @endif
                </div>
            </div>
        </div>
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>
@endsection
