@extends('layouts.Admin.adminForm')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content main_box">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <div class="box box-primary">
                    {{ Form::model($userDetail, array('route' => array($controllerUri.'.update', \Crypt::encryptString($userDetail->id)), 'method' => 'PUT', 'novalidate' => 'false', 'files' => true,'id'=>$formId)) }}

                    <div class="box-body form_box">
                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">First Name</label>
                                    {{ Form::text('first_name', $userDetail->first_name, ['class'=>'form-control required', 'id'=>'firstName','placeholder' => 'First Name', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Last Name</label>
                                    {{ Form::text('last_name', $userDetail->last_name, ['class'=>'form-control required', 'id'=>'lastName','placeholder' => 'Last Name', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                        </div>

                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="username">Username</label>
                                    {{ Form::text('user_name', $userDetail->user_name, ['class'=>'form-control required', 'id'=>'username','placeholder' => 'Username', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Email</label>
                                    {{ Form::email('', $userDetail->email, ['class'=>'form-control required customemail', 'id'=>'email','placeholder' => 'Email', 'onchange' => "return trim(this)" , 'disabled'=>'disabled']) }}
                                </div>
                            </div>
                        </div>
                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">

                                    <label for="exampleInputEmail1" class="col-md-12">Phone Number</label>
                                    <div class="col-md-3">
                                        <input value="+233" class="form-control" type="text" disabled>  
                                    </div>
                                    <div class="col-md-9">
                                    {{ Form::number('phone_number', !empty($userDetail->phone_number) ? $userDetail->phone_number : '', ['class'=>'form-control required', 'id'=>'phone_number','placeholder' => 'Phone number: eg; 9876543210', 'onchange' => "return trim(this)"]) }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Status</label>
                                    {{Form::select('status',[1 => 'Active', 0 => 'Inactive'], ((isset($userDetail->status) && is_numeric($userDetail->status)) ? $userDetail->status : 0), ['class'=>'form-control'])}}
                                </div>
                            </div>
                        </div>
                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-7">
                                        <div class="image-upload">
                                            <div class="file-label" style="text-align: left">Upload Image</div>
                                            {{ Form::file('avatar', ['id' => 'avatar']) }}
                                        </div>
                                    </div>
                                @if(!empty($userDetail->profile_image))
                                <div class="ImgPopup productimages" style="cursor: pointer"
                                        href="{{ $userDetail->profile_image }}">
                                    {{ Html::image($userDetail->profile_image, null, array('style' => 'max-width:100px;', 'id' => 'headshot_preview','title' => 'Image Preview')) }}
                                    </div>
                                @else
                                <div class="imgpreview" href="{{  $defaultAvatarUrl }}">
                                    {{ Html::image($defaultAvatarUrl, null, array('style' => 'max-width:100px;', 'id' => 'headshot_preview', 'title' => 'Image Preview')) }}
                                </div>
                                @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-footer row">
                        <div class="col-md-6">
                            {{ Form::submit('Submit', array('class'=>'btn btn-success pull-right')) }}
                        </div>
                        <div class="col-md-6">
                            <a href="{{route('customer.index')}}">
                                <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                            </a>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
@endsection