@extends('layouts.Admin.adminForm')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content main_box">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <div class="box box-primary">
                    <!-- /.box-header -->
                    <!-- form start -->
                    {!! Form::open(['route' => [$controllerUri.'.store'], 'method' => 'POST', 'id'=>
                    $formId, 'files' => true]) !!}
                    <div class="box-body form_box">
                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">First Name</label>
                                    {{ Form::text('first_name', null, ['class'=>'form-control required', 'id'=>'firstName','placeholder' => 'First Name', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Last Name</label>
                                    {{ Form::text('last_name', null, ['class'=>'form-control required', 'id'=>'lastName','placeholder' => 'Last Name', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                        </div>

                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="username">Username</label>
                                    {{ Form::text('user_name', null, ['class'=>'form-control required', 'autocomplete' => 'off', 'id'=>'username','placeholder' => 'Username', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Email</label>
                                    {{ Form::email('email', null, ['class'=>'form-control required customemail', 'id'=>'email','placeholder' => 'Email', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                        </div>

                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Phone Number</label>
                                    {{ Form::text('phone_number', null, ['class'=>'form-control', 'id'=>'phone_number','placeholder' => 'Phone number: eg; (111) 223-2332 | (222)233-2332 | 232-323-3233', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Mobile Number</label>
                                    {{ Form::text('mobile_no', null, ['class'=>'form-control', 'id'=>'mobile_no','placeholder' => 'Mobile number: eg; (111) 223-2332 | (222)233-2332 | 232-323-3233', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>
                        </div>

                        

                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Status</label>
                                    {{Form::select('status',[1 => 'Active', 0 => 'Inactive'], null, ['class'=>'form-control'])}}
                                </div>
                            </div>
                        </div>

                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-7">
                                        <div class="image-upload">
                                            <div class="file-label" style="text-align: left">Upload Image</div>
                                            {{ Form::file('avatar', ['id' => 'avatar']) }}
                                        </div>
                                    </div>
                                    <div class="imgpreview">
                                        {{ Html::image($defaultAvatarUrl, 'profile_image', array('style' => 'max-width:100px;', 'id' => 'headshot_preview', 'title' => 'Image Preview')) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer form-group ">
                        <div class="col-sm-6">
                            {{ Form::submit('Submit', array('class'=>'btn btn-success pull-right')) }}
                        </div>
                        <div class="col-sm-6">
                            <a href="{{route($controllerUri.'.index')}}">
                                <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                            </a>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
@endsection