@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get', 'class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'Title', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-2">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{$url}}" class="btn btn-default">Reset</a>
                                </div>
                                <div class="col-sm-2">
                                    <a href="{{$url.'/create'}}" title="Add Title"
                                        class="btn btn-primary pull-left addButton">+ Add Title</a>
                                </div>

                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($titleList) > 0)
                        <div class="adminusers_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="5%">Sr.No.</th>
                                        <th width="15%">Title</th>

                                        <th width="15%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $srNo = $limit*($page -1) + 1;
                                    @endphp
                                    @foreach($titleList as $user)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>

                                        <td>{{ !empty($user->name) ? $user->name : \config('admin.constants.EmptyNotation') }}
                                        </td>

                                        <td class="action-btn-permission">
                                            @include('elements.Admin.actions-link', ['row' => $user])
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}
                                </td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    @if(count($titleList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $titleList])
                    @endif
                </div>
            </div>
        </div>
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>
@endsection