@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get','class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'Name, Email', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-2">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{$url}}" class="btn btn-default">Reset</a>
                                </div>
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($contactSupportList) > 0)
                        <div class="roles_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Title</th>
                                        <th>Message</th>
                                        <th>Created On</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $page = empty(request()->get('page'))?1:request()->get('page');
                                    $srNo = config('admin.constants.AdminPageSize')*($page -1) + 1;
                                    @endphp
                                    @foreach($contactSupportList as $contactSupport)

                                 
                                    <tr>
                                        <td>{{ $srNo++ }}</td>

                                        <td>
                                            @if(!empty($contactSupport->users->full_name) || !empty($contactSupport->users->restaurant->name))
                                            @if($contactSupport->users->role_id == config('admin.constants.RESTAURANT_OWNER_ROLE'))
                                                <a href="{{url($adminUrl.'/restaurant/'.\Crypt::encryptString($contactSupport->users->restaurant->id))}}"
                                                class="various" data-fancybox-type="iframe"
                                                title="View">{{ !empty($contactSupport->users->restaurant->name) ? $contactSupport->users->restaurant->name :\config('admin.constants.EmptyNotation') }}</a>
                                            @else 
                                                <a href="{{url($adminUrl.'/customer/'.\Crypt::encryptString($contactSupport->users->id))}}"
                                                class="various" data-fancybox-type="iframe"
                                                title="View">{{ !empty($contactSupport->users->full_name) ? $contactSupport->users->full_name :\config('admin.constants.EmptyNotation') }}</a>
                                            @endif


                                            @else
                                            <span>{{ \config('admin.constants.EmptyNotation') }}</span>
                                            @endif
                                        </td>

                                        <td>
                                            {{ !empty($contactSupport->users->email) ? $contactSupport->users->email : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                        <td>
                                            {{ !empty($contactSupport->title->name) ? $contactSupport->title->name : $contactSupport->titleString }}
                                        </td>
                                        <td>
                                            {{ !empty($contactSupport->message) ? $contactSupport->message : \config('admin.constants.EmptyNotation') }}
                                        </td>

                                        <td>
                                            {{ \Carbon\Carbon::parse($contactSupport->created_at)->format('d M Y')}}
                                        </td>

                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}
                                </td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    <!-- /.box-body -->
                    @if(count($contactSupportList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $contactSupportList])
                    @endif
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
        <!-- /.col -->
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>
@endsection