@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get', 'class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'Name', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-2">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{$url}}" class="btn btn-default">Reset</a>
                                </div>
                                <div class="col-sm-2">
                                    <a href="{{$url.'/create'}}" title="Add Category"
                                        class="btn btn-primary pull-left addButton">+ Add Category</a>
                                </div>
                                
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($userList) > 0)
                        <div class="adminusers_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="5%">Sr.No.</th>
                                        <th width="15%">Category</th>
                                        <th width="15%">Image</th>
                                        <th width="15%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $srNo = $limit*($page -1) + 1;
                                    @endphp
                                    @foreach($userList as $user)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>
                                       
                                        <td>{{ !empty($user->name) ? $user->name : \config('admin.constants.EmptyNotation') }}</td>
                                        
                                        <td> 
                                           @if(!empty($user->image))
                                           <div class="ImgPopup productimages" style="cursor: pointer"
                                                href="{{ $user->image }}">
                                                {{ Html::image($user->image, '', array('width' => 50,'height' => 50, 'title' => 'Category Image')) }}
                                            </div>
                                            
                                            @else
                                            <div class="ImgPopup productimages" href="{{  $defaultAvatarUrl }}">
                                                {{ Html::image($defaultAvatarUrl, null, array('width' => 50, 'height' => 50)) }}
                                            </div>
                                            @endif
                                        </td>

                                        <td class="action-btn-permission">
                                            @include('elements.Admin.actions-link', ['row' => $user])


                                        <span style="float:left; margin-left:10px">
                                      @if($user->isFav==1) 
                                        <button type="submit" data-status="0" id="fav_{{$user->id}}" onclick="makefav({{$user->id}}, 0);" class="actions-btn pull-left fa fa-solid fa-heart" title="Make Unfavroite"  style="color:red"></button>   
                                       @else             
                                       
                                        <button type="submit" data-status="1" id="unf_{{$user->id}}" onclick="makefav({{$user->id}}, 1);" class="actions-btn pull-left
                                        fa fa-regular fa-heart" title="Make Favroite"></button> 
                                        @endif
                                        </span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    @if(count($userList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $userList])
                    @endif
                </div>
            </div>
        </div>
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";

function makefav(catID, status){
    if(status==0){
    var dstatus = $('#fav_'+catID).attr('data-status');
    }else{
        var dstatus = $('#unf_'+catID).attr('data-status');
    }
   
    console.log(dstatus);
    if(dstatus !=''){
        status = dstatus;
    }
        if(status ==1){
            var text = "Are you sure to make it favroite?";
            
        }else{
            var text = "Are you sure to make it unfavroite?";
 
        }
        var _token = $('meta[name="csrf-token"]').attr("content");

        let adminURL = "{{ \Config('admin.path.ADMIN_BASE_URL') }}";
        if (confirm(text) == true) { 

            $.ajax({
                url: adminURL + "/makeFavroite",
                type: "post",
                data: {
                    status: status,
                    id: catID,
                    _token: _token
                },
                success: function(data) {
                    if(status ==1){ 
                        $('#unf_'+catID).css('color','red');
                      

                        $('#unf_'+catID).attr('data-status',0);
                      
                        }else{
                            $('#fav_'+catID).css('color','');                           
                            $('#fav_'+catID).attr('data-status',1);
                        
                        }  


                        location.reload();
                }
            });

        };
 
       
}
</script>
@endsection
