@extends('layouts.Admin.adminForm')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>

    <!-- Main content -->
    <section class="content main_box">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <div class="box box-primary">
                    <!-- /.box-header -->
                    <!-- form start -->
                    {{ Form::model($userDetail, array('route' => array($controllerUri.'.update', \Crypt::encryptString($userDetail->id)), 'method' => 'PUT', 'novalidate' => 'false', 'files' => true,'id'=>$formId)) }}
                    <div class="box-body form_box">
                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Food Category</label>
                                    {{ Form::text('category', $userDetail->name, ['class'=>'form-control required', 'id'=>'name','placeholder' => 'Food Category', 'onchange' => "return trim(this)"]) }}
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Upload Category Image</label>
                                    {{ Form::file('image', ['id' => 'image' , 'accept'=>'image/*']) }}
                                </div>

                                @include('elements.Admin.file-preview' , ['file'=>$userDetail->image])
                            </div>
                           
                        </div>

                        
                        
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer form-group ">
                        <div class="col-sm-6">
                            {{ Form::submit('Submit', array('class'=>'btn btn-success pull-right')) }}
                        </div>
                        <div class="col-sm-6">
                            <a href="{{route($controllerUri.'.index')}}">
                                <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                            </a>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
@endsection