@extends('layouts.Admin.adminPdf')
@section('content')
<div class="content-wrapper" style="margin-left:0px !important;">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-body">
                        @if(count($blockUserListX) > 0)
                        <div class="roles_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>Blocked User</th>
                                        <th>Blocked By</th>
                                        <th>Reason</th>
                                        <th>Blocked On</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $page = empty(request()->get('page'))?1:request()->get('page');
                                    $srNo = config('admin.constants.AdminPageSize')*($page -1) + 1;
                                    @endphp
                                    @foreach($blockUserListX as $blockUser)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>

                                        <td>
                                            @if(!empty($blockUser->users->full_name))

                                                {{ $blockUser->users->full_name }}
                                            @else
                                            <span>
                                            {{ \config('admin.constants.EmptyNotation') }}
                                            </span>
                                            @endif
                                        </td>

                                        <td>
                                            @if(!empty($blockUser->blockedBy->full_name))

                                                {{ !empty($blockUser->blockedBy->full_name) ? $blockUser->blockedBy->full_name : \config('admin.constants.EmptyNotation') }}
                                            @else
                                            <span>{{ \config('admin.constants.EmptyNotation') }}</span>
                                            @endif
                                        </td>

                                        <td>
                                            {{ !empty($blockUser->blockedReason->reason) ? $blockUser->blockedReason->reason : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                        <td>
                                            {{ \Carbon\Carbon::parse($blockUser->created_at)->format('m/d/Y')}}
                                        </td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
        <!-- /.col -->
    </section>
</div>
@endsection
