@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get','class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'username', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-2">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{$url}}" class="btn btn-default">Reset</a>
                                </div>
                                <div class="col-sm-2 ">
                                    @include('elements.Admin.export-file-link')
                                </div>
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($blockUserList) > 0)
                        <div class="roles_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>Blocked User</th>
                                        <th>Blocked By</th>
                                        <th>Reason</th>
                                        <th>Blocked On</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $page = empty(request()->get('page'))?1:request()->get('page');
                                    $srNo = config('admin.constants.AdminPageSize')*($page -1) + 1;
                                    @endphp
                                    @foreach($blockUserList as $blockUser)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>

                                        <td>
                                            @if(!empty($blockUser->users->full_name))

                                            <a href="{{url($adminUrl.'/public-users/'.\Crypt::encryptString($blockUser->users->id))}}"
                                                class="various" data-fancybox-type="iframe"
                                                title="View">{{ !empty($blockUser->users->full_name) ? $blockUser->users->full_name :\config('admin.constants.EmptyNotation') }}</a>
                                            @else
                                            <span>{{ \config('admin.constants.EmptyNotation') }}</span>
                                            @endif
                                        </td>

                                        <td>
                                            @if(!empty($blockUser->blockedBy->full_name))

                                            <a href="{{url($adminUrl.'/public-users/'.\Crypt::encryptString($blockUser->blockedBy->id))}}"
                                                class="various" data-fancybox-type="iframe"
                                                title="View">{{ !empty($blockUser->blockedBy->full_name) ? $blockUser->blockedBy->full_name :\config('admin.constants.EmptyNotation') }}</a>
                                            @else
                                            <span>{{ \config('admin.constants.EmptyNotation') }}</span>
                                            @endif
                                        </td>

                                        <td>
                                            {{ !empty($blockUser->blockedReason->reason) ? $blockUser->blockedReason->reason : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                        <td>
                                            {{ \Carbon\Carbon::parse($blockUser->created_at)->format('m/d/Y')}}
                                        </td>
                                        <td class="action-btn-permission">

                                            <span style="float:left; margin:2px 10px;">
                                                <a href="javascript:void(0)" id="{{$blockUser->id}}"
                                                    data="{{\Crypt::encryptString($blockUser->id)}}"
                                                    baseUrl="{{$adminUrl.'/'.$controllerUri.'/'.\Crypt::encryptString($blockUser->id).'/edit'}}"
                                                    class="change-status-confirm"
                                                    msg="{{__('admin/flash_msg.error.ConfirmBlockedStatus')}}">
                                                    <span style="cursor:pointer"
                                                        class="glyphicon {{ ($blockUser->status==1)?'fa fa-unlock-alt':'fa fa-fw fa-ban' }}"
                                                        aria-hidden="true"
                                                        title="{{($blockUser->status==1)? 'Unblocked' : 'Blocked'}}">
                                                    </span>
                                                </a>
                                            </span>

                                            <span>
                                                {!! Form::open(['method' => 'DELETE', 'route' =>
                                                [$controllerUri.'.destroy',
                                                \Crypt::encryptString($blockUser->id)]]) !!}
                                                {!! Form::button('', [
                                                'type' => 'submit',
                                                'class' => 'actions-btn delete-confirm pull-left fa fa-check-square',
                                                'title' => 'Resolved',
                                                'msg' => __('admin/flash_msg.error.ConfirmResolved')
                                                ]) !!}
                                                {!! Form::close() !!}
                                            </span>
                                        </td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    <!-- /.box-body -->
                    @if(count($blockUserList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $blockUserList])
                    @endif
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
        <!-- /.col -->
    </section>
</div>
<script>
    let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>
@endsection
