@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get','class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'Reason', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-2">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{$url}}" class="btn btn-default">Reset</a>
                                </div>
                                <div class="col-sm-2">
                                    <a href="{{$url.'/create'}}" class="btn btn-primary pull-right addButton">+
                                        Create Blocked Reason</a>
                                </div>
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($blockReasonList) > 0)
                        <div class="roles_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>@sortablelink('reason', 'Reason')</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $page = empty(request()->get('page'))?1:request()->get('page');
                                    $srNo = config('admin.constants.AdminPageSize')*($page -1) + 1;
                                    @endphp
                                    @foreach($blockReasonList as $blockReason)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>
                                        <td>{{ $blockReason->reason }}</td>
                                        </td>
                                        <td>
                                            {{ \Carbon\Carbon::parse($blockReason->created_at)->format('m/d/Y')}}
                                        </td>
                                        <td class="action-btn-permission">
                                        <!-- change status of the resource -->
                                        <span style="float:left; margin:2px 10px;">
                                            <a href="javascript:void(0)" id="{{$blockReason->id}}" data="{{\Crypt::encryptString($blockReason->id)}}"
                                                baseUrl="{{$adminUrl.'/'.$controllerUri.'/'.\Crypt::encryptString($blockReason->id).'/edit'}}"
                                                model="{{ \Crypt::encryptString('blocked_reasons')}}" class="change-status-confirm"
                                                msg="{{__('admin/flash_msg.error.ConfirmChangeStatus')}}">
                                                <span style="cursor:pointer" class="glyphicon {{ ($blockReason->status==1)?'glyphicon-ok':'glyphicon-remove' }}"
                                                    aria-hidden="true" title="{{($blockReason->status==1)? 'Active' : 'Inactive'}}">
                                                </span>
                                            </a>
                                        </span>

                                        <!-- edit resource -->
                                        <span>
                                            {!! Form::open(['method' => 'GET', 'route' => [$controllerUri.'.edit',
                                            \Crypt::encryptString($blockReason->id)]]) !!}
                                            {!! Form::button('', ['type' => 'submit', 'class' => 'actions-btn pull-left
                                            fa fa-edit', 'title' => 'Edit']) !!}
                                            {!! Form::close() !!}
                                        </span>

                                        <!-- delete resource -->
                                        <span>
                                            {!! Form::open(['method' => 'DELETE', 'route' => [$controllerUri.'.destroy',
                                            \Crypt::encryptString($blockReason->id)]]) !!}
                                            {!! Form::button('', [
                                            'type' => 'submit',
                                            'class' => 'actions-btn delete-confirm pull-left fa fa-trash',
                                            'title' => 'Delete Title',
                                            'msg' => __('admin/flash_msg.error.ConfirmDelete')
                                            ]) !!}
                                            {!! Form::close() !!}
                                        </span>
                                        </td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    <!-- /.box-body -->
                    @if(count($blockReasonList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $blockReasonList])
                    @endif
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
        <!-- /.col -->
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>

@endsection
