@extends('layouts.Admin.adminForm')
@php
@endphp
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="box">
            <div class="box-body">
                <div class="row">
                    {{ Form::model($blockReasonDetail, ['route' => array($controllerUri.'.update', \Crypt::encryptString($blockReasonDetail->id)), 'method' => 'PUT', 'id'=>$formId, 'files' => true]) }}
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputName">Reason</label>
                            {{ Form::text('reason', null, ['class'=>'form-control required', 'id'=>'reason','placeholder' => 'Reason', 'onchange' => "return trim(this)"]) }}
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Status</label>
                            {{Form::select('status',[1 => 'Active', 0 => 'Inactive'], ((isset($blockReasonDetail->status) && is_numeric($blockReasonDetail->status)) ? $blockReasonDetail->status : 0), ['class'=>'form-control'])}}
                        </div>
                        <div class="form-group" style="text-align: center">
                            <span>{{ Form::submit('Submit', ['class'=>'btn btn-success']) }}</span>
                            <span style="margin-left: 10px">
                                <a href="{{route('blocked-reasons.index')}}">
                                    <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                </a>
                            </span>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </section>
</div>
<!-- /.row -->
</section>
<!-- /.content -->
</div>
@endsection