@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">

                        </div>
                    </div>
                    <div class="box-body">
                        <?php //echo "<pre>"; print_r($appVersion); ?>
                        @if(count($appVersion) > 0)
                        <div class="adminusers_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="10%">Sr.No.</th>
                                        <th width="15%">Android Version</th>
                                        <th width="15%">Ios Version</th>
                                        <th width="15%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $srNo = $limit*($page -1) + 1;
                                    @endphp 
                                    @foreach($appVersion as $value)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>
                                        <td>{{ $value->android_version }}</td>
                                        <td>{{ $value->ios_version }}</td>
                                       <td class="action-btn"> 
                                        @include('elements.Admin.app-version.action-link-version', ['row' => $value])
                                       </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @else

                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>
@endsection
