@extends('layouts.Admin.adminForm')

@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-body">
                <!-- left column -->
                <div class="box-body form_box">

                    {{ Form::model($appVersion, array('route' => array('app-version.update', \Crypt::encryptString($appVersion->id)), 'method' => 'PUT','files' => false,'id'=>$formId)) }}
                    <div class="row input_row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1">Android version</label>
                            {{ Form::text('android_version', null, array('class'=>'form-control required')) }}
                        </div>
                    </div>
                        <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1">Ios version</label>
                            {{ Form::text('ios_version', null, array('class'=>'form-control required')) }}
                        </div>
                        </div>
                    </div>
                    <div class="row input_row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="username">Android update message</label>
                                {{ Form::textarea('android_update_message', null, array('class'=>'form-control required','rows'=>'3')) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="username">Ios update message</label>
                                {{ Form::textarea('ios_update_message', null, array('class'=>'form-control required','rows'=>'3')) }}
                            </div>
                        </div>
                    </div>

                    <div class="row input_row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="username">Do android app require force update ?</label>
                            {{ Form::select('force_update_android',\app\Enums\AppUpdateForceType::SelectArrayExcept([\app\Enums\AppUpdateForceType::Idle]), null, array('class'=>'form-control required')) }}
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="password">Do ios app require force update?</label>
                            {{  Form::select('force_update_ios',\app\Enums\AppUpdateForceType::SelectArrayExcept([\app\Enums\AppUpdateForceType::Idle]), null, array('class'=>'form-control required')) }}
                        </div>
                    </div>
                        </div>
                    </div>
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="col-md-6">
                                {{ Form::submit('Submit', array('class'=>'btn btn-success pull-left', 'style' =>'margin: 0 0 0 -18px;'  )) }}
                                <span style="margin-left: 10px">
                                <a href="{{Url('/secureadmin/app-version')}}">
                                    <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                </a>
                            </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
<script>
let baseURL = "{{\Config('admin.path.BASE_URL')}}";
</script>
@endsection