@extends('layouts.Admin.adminForm')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    {{ Form::model($user, array('files' => true, 'method' => 'PUT','id' => $formId)) }}
                    <div class="box-body">
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-6 col-xs-6">
                                    <label for="exampleInputEmail1">First Name</label>
                                    {{ Form::text('first_name', !empty($user) ? $user->first_name : '', array('class'=>'form-control required', 'id'=>'firstName','placeholder' => 'First Name')) }}
                                    {{ Form::hidden('id', !empty($user) ? $user->id : '') }}
                                </div>
                                <div class="col-md-6  col-xs-6">
                                    <label for="exampleInputEmail1">Last Name</label>
                                    {{ Form::text('last_name', !empty($user) ? $user->last_name : '', array('class'=>'form-control required', 'id'=>'lastName','placeholder' => 'Last Name')) }}
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-6  col-xs-6">
                                    <label for="exampleInputEmail1">Email Id</label>
                                    {{ Form::text('email', !empty($user) ? $user->email : '', array('class'=>'form-control required email', 'id'=>'emailId','placeholder' => 'Email Id', 'disabled' => 'true')) }}
                                </div>
                                <div class="col-md-6  col-xs-6">
                                    <label for="exampleInputMobile">Username</label>
                                    {{ Form::text('user_name',!empty($user) ? $user->user_name : '', array('class'=>'form-control required', 'placeholder' => 'Username','id'=>'username', 'disabled' => 'true')) }}
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-6  col-xs-6">
                                    <label for="exampleInputEmail1">Profile Image</label>
                                    {{ Form::file('avatar', ['id' => 'avatar']) }}
                                    {{ Form::hidden('profile_image_edit', (!empty($user) && is_object($user) && !empty($user->profile_image) ? $user->profile_image : '')) }}
                                </div>

                                <?php 
                                    $avtarImage = \app\Helpers\CommonHelper::getImageUri($user->id);
                                ?>
                                @if(!empty($avtarImage))
                                <div class="imgpreview ImgPopup" style="cursor: pointer"
                                    href="{{ $avtarImage['origional'] }}">
                                    {{ Html::image($avtarImage['origional'], '', array('style' => 'max-width:100px;', 'id' => 'headshot_preview','title' => 'Image Preview')) }}
                                </div>
                                @else
                                <div class="imgpreview" href="{{  $defaultAvatarUrl }}">
                                    {{ Html::image($defaultAvatarUrl, 'profile_image', array('style' => 'max-width:50px;', 'id' => 'headshot_preview', 'title' => 'Image Preview')) }}
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-2">
                                    {{ Form::submit('Submit', array('class'=>'btn btn-success btn-block btn-flat')) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </section>
</div>
@endsection