@extends('layouts.Admin.adminLogin')
@php
$emailFlag = $passFlag = false;
@endphp
@section('content')
<div class="login-box">
    <div class="login-logo">
        <a href="{{url('/'.\Config::get("admin.constants.ADMIN_ROUTE_NAME"))}}"><b>{{\Config::get('admin.constants.BOLD_TITLE')}}
            </b>{{\Config::get('admin.constants.REGULAR_TITLE')}}</a>
    </div>
    <!-- /.login-logo -->
    <div class="login-box-body">
        @include('Admin.flash_message')
        <?php
            if (!isset($_COOKIE['admin_remember']) && empty($_COOKIE['admin_remember'])) {

            $userName= null;
            $password= null;
            $rememberMe = null;
        } else {
            //echo "set";
            $decodeValue = base64_decode($_COOKIE['admin_remember']);
            $jsonDecodeValue = json_decode($decodeValue);
            $userName = !empty($jsonDecodeValue->userName)? $jsonDecodeValue->userName:Null;
            $password = !empty($jsonDecodeValue->password)? $jsonDecodeValue->password:Null;
            $rememberMe = !empty($jsonDecodeValue->rememberMe)? $jsonDecodeValue->rememberMe:Null;
           //dd(base64_decode($_COOKIE['salon_remember']));
        }?>
        <p class="login-box-msg">Sign in to start your session</p>
        {!! Form::open(['method' => 'POST', 'id'=> $formId]) !!}
        @csrf
        <div class="form-group has-feedback">
            {{ Form::email('email', $userName, array('class'=>'form-control required email', 'id'=>'email','placeholder' => 'Email')) }}
        </div>
        <div class="form-group has-feedback">
            {{ Form::input('password', 'password', $password,array('class'=>'form-control required', 'placeholder' => 'Password'))}}
        </div>
        <div class="row">
            <div class="col-xs-6">
            <div class="social-auth-links">
                <a href="{{$url.'/forgot-password'}}">I forgot my password</a>
            </div>
            </div>
            <!-- /.col -->
            <div class="col-xs-6">
                <button type="submit" class="btn btn-primary pull-right">{{ __('Login') }}</button>
            </div>
            <!-- /.col -->
        </div>
        <!-- <div class="row">
            
        </div> -->
        {{Form::close()}}
        <!-- /.social-auth-links -->
        @if (Route::has('password.request'))
        <a href="{{ route('password.request') }}">
            {{ __('I forgot my password?') }}
        </a>
        @endif
    </div>
    <!-- /.login-box-body -->
</div>
<!-- /.login-box -->
@endsection
