@extends('layouts.Admin.adminDatagrid')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}}<small>{{$subTitle}}</small></h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Dashboard</a></li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3>{{ !empty($getFacility) ? 1 : 0 }}</h3>
                        <p>{{ !empty($getFacility->name) ? $getFacility->name : config('flash_msg.NoRecordFound') }}
                        </p>
                    </div>
                    <div class="icon">
                    <i class="ion ion-stats-bars"></i>
                        <a class="ImgPopup productimages"
                            href="{{!empty($getFacility->logo) && File::exists($logoStoragePath .'/'. $getFacility->id.'/'.$getFacility->logo) ? $logoBaseUrl .'/'. $getFacility->id.'/'.$getFacility->logo :'#'}}"
                            title="{{ !empty($getFacility->name) ? $getFacility->name : config('flash_msg.NoRecordFound') }}">
                            {{!empty($getFacility->logo) && File::exists($logoStoragePath .'/'. $getFacility->id.'/tmb_'. $getFacility->logo) ? Html::image($logoBaseUrl .'/'. $getFacility->id.'/tmb_'. $getFacility->logo,null ,['width' => 50,'height' => 50, 'class' => 'img-circle']) : Html::image($defaultLogoUrl,null,['width' => 50,'height' => 50, 'class' => 'img-circle'])  }}
                        </a>
                    </div>
                    @php
                    $facitliyUrl = !empty($getFacility) ? $url.'/edit-facility' : '#';
                    @endphp
                    <a href="{{$facitliyUrl}}" class="small-box-footer">Manage Report<i
                            class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3>{{ !empty($medicalWorkerCount) ? $medicalWorkerCount : '0' }}</h3>
                        <p>Public Users</p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-person-add"></i>
                    </div>
                    <a class="small-box-footer" href="{{$url.'/public-users'}}">View Public Users <i
                            class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3>{{ !empty($titleCount) ? $titleCount : '0' }}</h3>
                        <p>Mailbox</p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-bag"></i>
                    </div>
                    <a href="{{$url.'/titles'}}" class="small-box-footer">View Mail Inbox <i
                            class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>{{ !empty($allDeptCount) ? $allDeptCount : '0' }}</h3>
                        <p>Manage Department</p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                    </div>
                    <a href="{{$url.'/dirdepartments'}}" class="small-box-footer">View Departments <i
                            class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
        </div>
        <!-- /.row -->
        <!-- TABLE: LATEST ORDERS -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><strong>Recent Medical Workers</strong></h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-box-tool" data-widget="remove"><i
                            class="fa fa-times"></i></button>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <div class="table-responsive">
                    @if($medicalWorkers->count() > 0)
                    <table class="table no-margin">
                        <thead>
                            <tr>
                                <th>Sr.No.</th>
                                <th>Full Name</th>
                                <th>Email</th>
                                <th>Image</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            $srNo = 1;
                            @endphp
                            @foreach($medicalWorkers as $user)
                            <tr>
                                <td>{{ $srNo++ }}</td>
                                <td>
                                    <a href="{{url($url.'/public-users/'.\Crypt::encryptString($user->id))}}"
                                        class="various" data-fancybox-type="iframe"
                                        title="View">{{ $user->full_name }}</a>
                                </td>
                                <td>{{$user->email}}</td>
                                <td>
                                    <a class="ImgPopup productimages"
                                        href="{{!empty($user->id) && !empty($user->latestAvatar) && File::exists($avatarStoragePath .'/'. $user->id.'/'.$user->latestAvatar->avatar) ? $avatarBaseUrl .'/' . $user->id.'/'.$user->latestAvatar->avatar :' '}}"
                                        title="{{ $user->user_name }}">
                                        {{!empty($user->id) && !empty($user->latestAvatar) && File::exists($avatarStoragePath .'/'. $user->id.'/tmb_'. $user->latestAvatar->avatar) ? Html::image($avatarBaseUrl .'/'. $user->id.'/tmb_'. $user->latestAvatar->avatar,null ,['width' => 50,'height' => 50]) : Html::image($defaultAvatarUrl,null,['width' => 50,'height' => 50])  }}
                                    </a>
                                </td>
                                <td>
                                    <span
                                        class="label {{ $user->status ? "label-success" : "label-danger" }}">{{$user->status?"Active":"Inactive"}}</span>
                                </td>

                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @else
                    <table class="table">
                        <tr>
                            <td colspan="10" class="text-danger text-center error-msg">
                                {{config('flash_msg.NoRecordFound')}}</td>
                        </tr>
                    </table>
                    @endif
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix">
                <!--<a href="javascript:void(0)" class="btn btn-sm btn-primary btn-flat pull-left">Add New User</a>-->
                <a href="{{$url.'/medical-workers'}}" class="btn btn-sm btn-default btn-flat pull-right">View All
                    Medical Workers</a>
            </div>
            <!-- /.box-footer -->
        </div>
        <!-- /.box -->
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->
@endsection
