@extends('layouts.Admin.adminForm')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-6">
                <!-- general form elements -->
                <div class="box box-primary">
                    <!-- /.box-header -->
                    <!-- form start -->
                    {{ Form::open(array( 'method' => 'POST','id'=>$formId)) }}
                    <div class="box-body">
                        <div class="form-group">
                            <label>Current Password</label>
                            {{ Form::password('password', array('class'=>'form-control required', 'id'=>'password','placeholder' => 'Current Password')) }}
                        </div>
                        <div class="form-group">
                            <label>New Password</label>
                            {{ Form::password('new_password', array('class'=>'form-control required', 'id'=>'new_password','placeholder' => 'New Password')) }}
                        </div>
                        <div class="form-group">
                            <label>Confirm Password</label>
                            {{ Form::password('new_password_confirmation', array('class'=>'form-control required', 'placeholder' => 'Confirm New Password')) }}
                        </div>
                    </div>
                    <div class="box-footer">
                        <div class="col-md-6">
                            {{ Form::submit('Submit', array('class'=>'btn btn-success pull-right')) }}
                        </div>
                        <div class="col-sm-6">
                            <a href="{{$url}}">
                                <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                            </a>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
            <!--/.col (left) -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
@endsection