@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get', 'class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'Email or Name', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-2">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{$url}}" class="btn btn-default">Reset</a>
                                </div>
                                <div class="col-sm-2">
                                    <a href="{{$url.'/create'}}" title="Add Admin User"
                                        class="btn btn-primary pull-left addButton">+ Add Admin User</a>
                                </div>
                                <div class="col-sm-2 ">
                                    @include('elements.Admin.export-file-link')
                                </div>
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($userList) > 0)
                        <div class="adminusers_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="5%">Sr.No.</th>
                                        <th width="5%">Image</th>
                                        <th width="15%">@sortablelink('user_name', 'Username')</th>
                                        <th width="25%">@sortablelink('email')</th>
                                        <th width="10%">@sortablelink('first_name', 'First Name')</th>
                                        <th width="10%">@sortablelink('last_name', 'Last Name')</th>
                                        <th width="15%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $srNo = $limit*($page -1) + 1;
                                    @endphp
                                    @foreach($userList as $user)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>
                                        <td>
                                        @php
                                        $facilityUserImage = \app\Helpers\CommonHelper::getuserAvatarUri($user->id);
                                    @endphp
                                    @if(!empty($facilityUserImage))
                                    <div class="ImgPopup productimages" style="cursor: pointer"
                                        href="{{ $facilityUserImage['origional'] }}">
                                        {{ Html::image($facilityUserImage['origional'], '', array('width' => 50,'height' => 50, 'title' => $user->profile_image)) }}
                                    </div>
                                    @else
                                    <div class="imgpreview" href="{{  $defaultAvatarUrl }}">
                                        {{ Html::image($defaultAvatarUrl, null, array('width' => 50, 'height' => 50)) }}
                                    </div>
                                    @endif
                                        </td>
                                        </td>
                                        <td>
                                            <a href="{{url($url.'/'.\Crypt::encryptString($user->id))}}" class="various"
                                                data-fancybox-type="iframe" title="View">{{ $user->user_name }}</a>
                                        </td>
                                        <td>{{ !empty($user->email) ? $user->email : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                        <td>{{ !empty($user->first_name) ? $user->first_name : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                        <td>{{ !empty($user->last_name) ? $user->last_name : \config('admin.constants.EmptyNotation') }}
                                        </td>

                                        <!--<td id="{{$user->id}}" data="{{\Crypt::encryptString($user->id)}}"
                                            baseUrl="{{\Config('admin.path.ADMIN_BASE_URL').'/facility-users/'.\Crypt::encryptString($user->id).'/edit'}}"
                                            model="{{ \Crypt::encryptString("users")}}"
                                            class="change-status-confirm {{$user->status }}"
                                            msg="{{__('admin/flash_msg.error.ConfirmChangeStatus')}}">
                                            <span style=" cursor:pointer" class="glyphicon {{ ($user->status==1)?'glyphicon-ok':'glyphicon-remove' }}
                                                  " aria-hidden="true"
                                                title="{{($user->status==1)? 'Active' : 'Block'}}"></span>

                                        </td> -->
                                        <td class="action-btn-permission">
                                            @include('elements.Admin.actions-link', ['row' => $user])
                                        </td>
                                        <!-- <td class="action-btn">
                                            {!! Form::open(['method' => 'GET', 'route' => [$controllerUri.'.edit',
                                            \Crypt::encryptString($user->id)]]) !!}

                                            {!! Form::button('',['type' => 'submit', 'class' => 'pull-left fa
                                            fa-edit', 'title' => 'Edit Facility User']) !!}
                                            {!! Form::close() !!}

                                            {!! Form::open(['method' => 'DELETE', 'route' => [$controllerUri.'.destroy',
                                            \Crypt::encryptString($user->id)]]) !!}
                                            {!! Form::button('', [
                                            'type' => 'submit',
                                            'class' => 'delete-confirm pull-left fa fa-trash',
                                            'title' => 'Delete Facility User',
                                            'msg' => __('admin/flash_msg.error.ConfirmDelete')
                                            ]) !!}
                                            {!! Form::close() !!}
                                        </td> -->
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    @if(count($userList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $userList])
                    @endif
                </div>
            </div>
        </div>
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>
@endsection
