<?php

/**
 * Author: NMG
 * Description: Constants messages used in user api module
 * Dated: 10/Dec/2019
 */
return [
    'email' => [
        'code' => '102',
        'required' => 'The email field is required.',
        'string' => 'The email must be a string.',
        'email' => 'The email must be a valid email address.',
        'max' => 'The email may not be greater than ' . config('api.constants.user.email.maxLength') . ' characters.',
        'unique' => 'The email has already been taken.',
        'exists' => 'Your email is not registered with us.',
    ],

    'password' => [
        'code' => '103',
        'required' => 'The password field is required.',
        'string' => 'The password must be a string.',
        'min' => 'The password must be at least ' . config('api.constants.user.password.minLength') . ' characters.',
        'max' => 'The password may not be greater than ' . config('api.constants.password.email.maxLength') . ' characters.',
        'regex' => 'The password should have consist with at lest one uppercase, one lowercase, one special charecter & a number.',
        'currentPassword' => 'The current password is incorrect.',
        'confirmed' => 'The password confirmation does not match.',
    ],
    'passwordConfirmation' => [
        'code' => '104',
        'same' => 'The password confirmation and password must match.',
    ],
    'newPassword' => [
        'code' => '104',
        'required' => 'The new password field is required.',
        'string' => 'The new password must be a string.',
        'min' => 'The new password must be at least ' . config('api.constants.user.password.minLength') . ' characters.',
        'max' => 'The new password may not be greater than ' . config('api.constants.user.password.maxLength') . ' characters.',
        'regex' => 'The new password should have consist with at lest one uppercase, one lowercase, one special charecter & a number.',
        'different' => 'The new password and password must be different.',
        'currentPassword' => 'The current password is incorrect.',
    ],
    'userName' => [
        'code' => '105',
        'required' => 'Username is required.',
        'min' => 'Username must be at least ' . config('api.constants.user.userName.minLength') . ' characters.',
        'max' => 'Username may not be greater than ' . config('api.constants.user.userName.email.maxLength') . ' characters.',
        'regex' => 'Username format is invalid.',
    ],
    'firstName' => [
        'code' => '106',
        'required' => 'The first name field is required.',
        'string' => 'The first name must be a string.',
        'min' => 'The first name must be at least ' . config('api.constants.user.firstName.minLength') . ' characters.',
        'max' => 'The first name may not be greater than ' . config('api.constants.user.firstName.maxLength') . ' characters.',
        'regex' => 'The first name format is invalid.',
    ],
    'lastName' => [
        'code' => '107',
        'required' => 'The last name field is required.',
        'string' => 'The last name must be a string.',
        'min' => 'The last name must be at least ' . config('api.constants.user.lastName.minLength') . ' characters.',
        'max' => 'The last name may not be greater than ' . config('api.constants.user.lastName.maxLength') . ' characters.',
        'regex' => 'The last name format is invalid.',
    ],
    'avatar' => [
        'code' => '108',
        'required' => 'The avatar image is required.',
        'image' => 'The avatar must be an image.',
        'mimes' => 'The avatar must be a file of type: ' . config('api.constants.user.avatar.mimes') . '.',
        'filesize' => 'The avatar may not greater than ' . config('api.constants.user.avatar.size') . ' kbs.',
    ],

    'mobile_no' => [
        'code' => '109',
        'required' => 'The mobile_no field is required.',
        'string' => 'The mobile_no must be a string.',
        'email' => 'The mobile_no must be a valid mobile_no address.',
        'max' => 'The mobile_no may not be greater than ' . config('api.constants.user.mobile_no.maxLength') . ' characters.',
        'unique' => 'The mobile_no has already been taken.',
        'exists' => 'Your mobile_no is not registered with us.',
    ],

    'phone_no' => [
        'code' => '110',
        'required' => 'The phone number field is required.',
        'string' => 'The phone number must be a string.',
        'max' => 'The phone number may not be greater than ' . config('api.constants.user.phone_number.maxLength') . ' characters.',
        'unique' => 'The phone number has already been taken.',
        'exists' => 'Your phone number is not registered with us.',
    ],
    'phone' => [
        'code' => '110',
        'required' => 'The phone number field is required.',
        'string' => 'The phone number must be a string.',
        'max' => 'The phone number may not be greater than ' . config('api.constants.user.phone_number.maxLength') . ' characters.',
        'unique' => 'The phone number has already been taken.',
        'exists' => 'Your phone number is not registered with us.',
    ],
    'otp' => [
        'code' => '111',
        'required' => 'The otp field is required.',
        'numeric' => 'The otp must be a numeric.',
        'min' => 'The otp may not be greater than ' . config('api.constants.user.otp.minLength') . ' characters.',

    ],
    'deviceToken' => [
        'code' => '112',
        'required' => 'The device token is required.',
    ],
    'deviceType' => [
        'code' => '113',
        'required' => 'The device type is required.',
        'in' => 'Type device type must be one of values[1,2]',
    ],
    'rider' => [
        'notIn' => 'User is already assigned as driver'
    ],
    'success' => [
        'default' => 'success',
        'register' => 'You have been successfully signed up',
        'login' => 'You have been successfully logged in.',
        'reset' => 'New password sent successfully.',
        'profile' => 'Your profile has been successfully fetched.',
        'profileUpdated' => 'Your profile has been successfully updated.',
        'avatar' => 'Your profile image has been successfully updated.',
        'changePassword' => 'Your password has been changed successfully.',
        'logout' => 'You are successfully logged out.',
        'refreshToken' => 'You have successfully generated refresh token.',
        'mwList' => 'Medical workers found.',
        'notificationSettingUpdated' => 'Your Notfication Setting has been successfully updated.',
        'notificationSettingAlreadyUpdated' => 'Your Notfication Setting has been already  updated.',
        'notificationGetting' => 'Your Notfication Setting has been fetched successfully.',
        'voipTokenSaved' => 'Voip Token saved successfully.',
        'otpSend' => 'Otp sent successfully, please check your mail / phone Inbox',
        'otpSendMobile' => 'A verification code has been sent on your number',
        'otp_verified' => 'OTP verified successfully',
        'video_uploaded' => 'Your Media is uploaded successfully',
        'email_verified' => 'Your email is verified successfully',
        'mobile_verified' => 'Thanks! Your mobile number is verified',
        'mobile_updated' => 'Your mobile is updated successfully',
        'addresses_list_fetch' => 'Your addresses have been fetched',
        'address_fetch' => 'Your address have been fetched',
        'address_added' => 'Your address has been saved successfully',
        'address_updated' => 'Your address has been updated successfully',
        'address_deleted' => 'Your address has been deleted successfully',
        'notification-enabled' => 'App Notification has been enabled',
        'notification-disabled' => 'App Notification has been disabled',
        'email_updated' => 'Your email has been updated successfully',
        'profile_deactivated' => 'Profile has been deactivated successfully',
    ],
    'error' => [
        'register' => 'Unable to signed up.',
        'login' => 'Invalid phone or password.',
        'blocked' => 'Your account has been suspended, please contact your site administrator.',
        'profile' => 'Unable to fetch profile.',
        'reset' => 'Unable to reset your password.',
        'profileUpdated' => 'Unable to update your profile.',
        'avatar' => 'Unable to update your profile image.',
        'changePassword' => 'Unable to Change Your password.',
        'mwList' => 'User not found.',
        'notificationSettingUpdated' => 'Unable to update Your Notfication Setting.',
        'notificationGetting' => 'Your Notfication Setting has been not fetched successfully.',
        'notFound' => 'user id not found.',
        'voipTokenSaved' => 'Voip Token already saved.',
        'userNotFound' => 'Seems no any user exist with this email',
        'emailNotMatched' => 'Email mismatched',
        'otp_error' => 'Something going wrong while verifying your OTP',
        'otp_invalid' => 'Invalid OTP',
        'otp_expired' => 'OTP has been expired',
        'otp_send_error' => 'Something going wrong while sending OTP',
        'video_error' => 'There are some error while uploading your video',
        'email_otp_error' => 'Your otp is not valid',
        'mobile_otp_error' => 'Your otp is not valid',
        'account_varification' => 'Something going wrong while verifying your account',
        'phone_error' => 'Phone is not registered with us.',
        'wrong_otp' => 'Verification code is invalid.',
        'address_added' => '!Sorry Your address could not be saved',
        'address_updated' => '!Sorry Your address could not be updated successfully',
        'notOwned' => 'You are not associated with this address.',
        'address_deleted' => 'Your address could not be deleted',
        'sameEmailError' => 'existing and new email are same',
        'email_updated' => 'Your email could not be updated',

    ],
];
