<?php

/**
 * Author: NMG
 * Description: Group of validation messages for user module client/server both
 * Dated: 20/Nov/2019
 */

// All validations used for users module
return [
    'role_id' => [
        'code' => '101',
        'required' => 'The role field is required.',
    ],
    'facility_id' => [
        'code' => '101',
        'required' => 'The facility field is required.',
    ],
    'department_id' => [
        'code' => '102',
        'required' => 'The department field is required.',
    ],
    'title_id' => [
        'code' => '103',
        'required' => 'The title field is required.',
    ],
    'user_name' => [
        'code' => '104',
        'required' => 'The username field is required.',
        'string' => 'The username must be a string.',
        'min' => 'The username must be at least ' . config('admin.constants.user.user_name.minLength') . ' characters.',
        'max' => 'The username may not be greater than ' . config('admin.constants.user.user_name.maxLength') . ' characters.',
        'regex' => 'The username can consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],
    'email' => [
        'code' => '105',
        'required' => 'The email field is required.',
        'email' => 'The email must be a valid email address.',
        'regex' => 'Please enter a valid email address.',
        'min' => 'The email may not be less than ' . config('admin.constants.user.email.minLength') . ' characters.',
        'max' => 'The email may not be greater than ' . config('admin.constants.user.email.maxLength') . ' characters.',
        'unique' => 'The email has already been taken.',
        'exists' => 'Your email is not registered with us.',
    ],
    'phone_number' => [
        'min' => 'The phone number may not be less than ' . config('admin.constants.user.phone_number.minLength') . ' characters.',
        'max' => 'The phone number may not be greater than ' . config('admin.constants.user.phone_number.maxLength') . ' characters.',
        'regex' => 'The Phone Number Format should be 2323233233',
    ],
    'mobile_no' => [
        'required' => 'The mobile number field is required.',
        'min' => 'The mobile number may not be less than ' . config('admin.constants.user.mobile_no.minLength') . ' characters.',
        'max' => 'The phone number may not be greater than ' . config('admin.constants.user.mobile_no.maxLength') . ' characters.',
        'regex' => 'The mobile Number Format should be (111) 223-2332 | (222)233-2332 | 232-323-3233',
    ],


    'password' => [
        'code' => '106',
        'required' => 'The password field is required.',
        'string' => 'The password must be a string.',
        'min' => 'The password must be at least ' . config('admin.constants.user.password.minLength') . ' characters.',
        'max' => 'The password may not be greater than ' . config('admin.constants.user.password.maxLength') . ' characters.',
        'regex' => 'The password should have consist with at lest one uppercase, one lowercase, one special character & a number.',
        'current_password' => 'The current password is incorrect.',
        'old_password' => 'The old password is incorrect.',
    ],
    'confirm_password' => [
        'code' => '107',
        'required' => 'The confirm password field is required.',
        'equalTo' => 'Confirm password must be same as password.',
    ],
    'new_password' => [
        'code' => '108',
        'required' => 'The new password field is required.',
        'string' => 'The new password must be a string.',
        'min' => 'The new password must be at least ' . config('admin.constants.user.password.minLength') . ' characters.',
        'max' => 'The new password may not be greater than ' . config('admin.constants.user.password.maxLength') . ' characters.',
        'regex' => 'The new password should have consist with at lest one uppercase, one lowercase, one special character & a number.',
        'different' => 'The new password and password must be different.',
        'current_password' => 'The current password is incorrect.',
    ],
    'new_password_confirmation' => [
        'code' => '109',
        'required' => 'The confirm new password field is required.',
        'string' => 'The confirm new password must be a string.',
        'min' => 'The confirm new password must be at least ' . config('admin.constants.user.password.minLength') . ' characters.',
        'max' => 'The confirm new password may not be greater than ' . config('admin.constants.user.password.maxLength') . ' characters.',
        'regex' => 'The confirm new password should have consist with at lest one uppercase, one lowercase, one special character & a number.',
        'equalTo' => 'Confirm new password must be same as new password.',
    ],
    'first_name' => [
        'code' => '110',
        'required' => 'The first name field is required.',
        'string' => 'The first name must be a string.',
        'min' => 'The first name must be at least ' . config('admin.constants.user.first_name.minLength') . ' characters.',
        'max' => 'The first name may not be greater than ' . config('admin.constants.user.first_name.maxLength') . ' characters.',
        'regex' => 'The first name can consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],
    'last_name' => [
        'code' => '111',
        'required' => 'The last name field is required.',
        'string' => 'The last name must be a string.',
        'min' => 'The last name must be at least ' . config('admin.constants.user.last_name.minLength') . ' characters.',
        'max' => 'The last name may not be greater than ' . config('admin.constants.user.last_name.maxLength') . ' characters.',
        'regex' => 'The last name can consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],
    'avatar' => [
        'code' => '112',
        'required' => 'The avatar image is required.',
        'image' => 'The avatar must be an image.',
        'mimes' => 'The avatar must be a file of type: ' . config('admin.constants.user.avatar.mimes') . '.',
        'filesize' => 'The avatar may not greater than ' . config('admin.constants.user.avatar.size') . ' kbs.',
    ],

    'token' => [
        'code' => '113',
        'required' => 'The reset token required.',
    ],
    'success' => [
        'ConfirmDelete' => 'Are you sure you want to delete this?',
        'reset' => 'New password sent successfully.',
    ],
    'error' => [
        'reset' => 'Unable to reset your password.',
        'blocked' => 'Your account has been suspended, please contact your site administrator.',

    ],
];
