<?php
/**
 * Author: NMG
 * Description: Group of validation messages for role module client/server both
 * Dated: 27/Nov/2019
 */

// All validations used for users module
return [
    'name' => [
        'code' => '101',
        'required' => 'Role name field is required.',
        'unique' => 'Role name has already been taken.',
        'min' => 'Role name must be at least ' . config('admin.constants.role.name.minLength') . ' characters.',
        'max' => 'Role name may not be greater than ' . config('admin.constants.role.name.maxLength') . ' characters.',
        'regex' => 'Role name can consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],
    'description' => [
        'code' => '102',
        'required' => 'The description field is required.',
        'max' => 'The email may not be greater than ' . config('admin.constants.role.description.maxLength') . ' characters.',
    ],
    'success' => [
        'ConfirmDelete' => 'Are you sure you want to delete this?',
    ],
    'error' => [

    ],
];
