<?php
/**
 * Author: NMG
 * Description: Group of validation messages for General Setting module client/server both
 * Dated: 5/Jul/2021
 */

// All validations used for General Setting module
return [
    'food_category_id' => [
        'code' => '101',
        'required' => 'The Item Category field is required.',
        
    ],
    'name' => [
        'code' => '102',
        'required' => 'The item name field is required.',
        'min' => 'The item name may not be less than ' . config('admin.constants.restaurant-menu.name.minLength') . ' numbers.',
        'max' => 'The item name may not be greater than ' . config('admin.constants.restaurant-menu.name.maxLength') . ' numbers.',
        'regex' => 'The item name consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],
    'description' => [
        'code' => '103',
        'required' => 'The description field is required.',
        'string' => 'The description must be a string.',
        'min' => 'The description must be at least ' . config('admin.constants.restaurant-menu.description.minLength') . ' characters.',
        'max' => 'The description must be at least ' . config('admin.constants.restaurant-menu.description.maxLength') . ' characters.',
        'regex' => 'The description can consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],
    'price' => [
        'code' => '104',
        'required' => 'The price field is required.',
        'regex' => 'Please enter price in valid format.',
        'min' => 'The price may not be less than ' . config('admin.constants.restaurant-menu.price.minLength') . ' characters.',
        'max' => 'The price may not be greater than ' . config('admin.constants.restaurant-menu.price.maxLength') . ' characters.',
    ],
    
    'prep_time' => [
        'code' => '105',
        'required' => 'The prep time field is required.',
        'regex' => 'Please enter minutes in valid format.',
        'min' => 'The prep time may not be less than ' . config('admin.constants.restaurant-menu.prep_time.minLength') . ' characters.',
        'max' => 'The prep time may not be greater than ' . config('admin.constants.restaurant-menu.prep_time.maxLength') . ' characters.',
        
    ],
    'image' => [
        'code' => '109',
        'required' => 'The item photo is required.',
        'image' => 'The item photo must be an image.',
        'mimes' => 'The item photo must be a file of type: ' . config('admin.constants.restaurant-menu.image.mimes') . '.',
        'filesize' => 'The item photo may not greater than ' . config('admin.constants.restaurant-menu.image.size') . ' kbs.',
    ],

    'token' => [
        'code' => '113',
        'required' => 'The reset token required.',
    ],
];
