<?php

/**
 * Author: NMG
 * Description: Group of validation messages for General Setting module client/server both
 * Dated: 16/Apr/2021
 */

// All validations used for General Setting module
return [

    'restaurant_name' => [
        'code' => '101',
        'required' => 'The restaurant name field is required.',
        'string' => 'The restaurant must be a string.',
        'min' => 'The restaurant must be at least ' . config('admin.constants.restaurant.restaurant_name.minLength') . ' characters.',
        'max' => 'The restaurant may not be greater than ' . config('admin.constants.restaurant.restaurant_name.maxLength') . ' characters.',
        'regex' => 'The username can consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],

    'restaurant_phone_number' => [
        'code' => '102',
        'required' => 'The phone number field is required.',
        'min' => 'The phone number may not be less than ' . config('admin.constants.user.phone_number.minLength') . ' numbers.',
        'max' => 'The phone number may not be greater than ' . config('admin.constants.user.phone_number.maxLength') . ' numbers.',
        'regex' => 'The Phone Number Format should be (111) 223-2332 | (222)233-2332 | 232-323-3233',
    ],

    'restaurant_bio' => [
        'code' => '103',
        'required' => 'The restaurant bio field is required.',
        'string' => 'The restaurant bio must be a string.',
        'min' => 'The restaurant bio must be at least ' . config('admin.constants.restaurant.restaurant_bio.minLength') . ' characters.',
        'max' => 'The restaurant bio must be at least ' . config('admin.constants.restaurant.restaurant_bio.maxLength') . ' characters.',
        'regex' => 'The bio can consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],
    'restaurant_email_id' => [
        'code' => '104',
        'required' => 'The email field is required.',
        'email' => 'The email must be a valid email address.',
        'regex' => 'Please enter a valid email address.',
        'min' => 'The email may not be less than ' . config('admin.constants.user.email.minLength') . ' characters.',
        'max' => 'The email may not be greater than ' . config('admin.constants.user.email.maxLength') . ' characters.',
        'unique' => 'The email has already been taken.',
        'exists' => 'Your email is not registered with us.',
    ],

    'restaurant_address' => [
        'code' => '105',
        'required' => 'The address1 field is required.',

    ],
    'delivery_time' => [
        'required' => 'The delivery time field is required.',
        'regex' => 'Please enter delivery time in given format i.e 15-30.',

    ],
    'restaurant_address2' => [
        'code' => '106',
        'required' => 'The address2 field is required.',

    ],
    'region' => [
        'code' => '114',
        'required' => 'The Region field is required.',

    ],
    'city' => [
        'code' => '107',
        'required' => 'The City field is required.',

    ],
    'zipcode' => [
        'code' => '108',
        'required' => 'The Zip Code field is required.',

    ],
    'deliverytime' => [
        'code' => '115',
        'required' => 'The Delivery time field is required.',
        'regex' => 'The Delivery time should be in range format like 15-20.',

    ],
    'termcondition' => [
        'code' => '116',
        'required' => 'Check this checkbox to continue.',

    ],
    'otp' => [
        'code' => '117',
        'required' => 'The verification code field is required.',
        'min' => 'The verification code must be at least ' . config('admin.constants.restaurant.otp.minLength') . ' numbers.',
        'max' => 'The verification code may not be greater than ' . config('admin.constants.restaurant.otp.maxLength') . ' numbers.',

    ],
    'avatar' => [
        'code' => '109',
        'required' => 'The restaurant image is required.',
        'image' => 'The avatar must be an image.',
        'mimes' => 'The avatar must be a file of type: ' . config('admin.constants.user.avatar.mimes') . '.',
        'filesize' => 'The avatar may not greater than ' . config('admin.constants.user.avatar.size') . ' kbs.',
    ],

    'token' => [
        'code' => '113',
        'required' => 'The reset token required.',
    ],
    'type' => [
        'code' => '114',
        'required' => 'The restaurant type is required.',
    ],
    'success' => [
        'ConfirmDelete' => 'Are you sure you want to delete this?',
        'reset' => 'New password sent successfully.',
    ],
    'error' => [
        'reset' => 'Unable to restaurant register please try again.',
        'blocked' => 'Your account has been suspended, please contact your site administrator.',
        'resetRestaurantOtp' => 'Please enter the verification code sent to your registered email Id',
        'wrong_otp' => 'Verification code is invalid.',

    ],
];
