<?php
/**
 * Author: NMG
 * Description: Group of validation messages for role module client/server both
 * Dated: 13/Jan/2020
 */

// All validations used for users module
return [
    'email' => [
        'required' => 'This field is required.',
        'required_if' => 'The email field is required when mail type is single.',
        'email' => 'Please enter valid email.',
        'exists' => 'The email does not exists with our database.',
        'regex' => 'Please enter valid (comma`,` separted) email(s).',
    ],
    'subject' => [
        'required' => 'This field is required.',
        'required_with' => 'The subject field is required when content is present.',
        'max' => 'The subject may not be greater than ' . config('admin.constants.mailbox.subject.maxLength') . ' characters.',
    ],
    'content' => [
        'required' => 'This field is required.',
        'required_with' => 'The content field is required when subject is present.',
    ],
    'push_title' => [
        'required' => 'This field is required.',
        'required_with' => 'The push title field is required when push content is present.',
        'max' => 'The push title may not be greater than ' . config('admin.constants.mailbox.push_title.maxLength') . ' characters.',
    ],
    'push_content' => [
        'required' => 'This field is required.',
        'required_with' => 'The push content field is required when push title is present.',
        'max' => 'The push content may not be greater than ' . config('admin.constants.mailbox.puch_content.maxLength') . ' characters.',
    ],
    'role_id' => [
        'required' => 'Please select at leat one role.',
        'required_if' => 'The role field is required when mail type is bulk.',
        'exists' => 'Selected role does not exists.',
    ],
    'facility_id' => [
        'required' => 'Please select at leat one facility.',
        'exists' => 'Selected facility does not exists.',
    ],
    'success' => [
        'sendEmail' => 'Are you sure you want to send email(s)?',
        'sent' => 'Email has been send successfuly.',
    ],
    'error' => [
        'wrong' => 'Something went wrong.',
        'unable' => 'Unable to log email history in database.',
        'blocked' => 'User account has been blocked.',
        'invalidType' => 'Invalid mailing type.',
        'sent' => 'Unable to sent notification(s).',
    ],
];
