<?php
/**
 * Author: NMG
 * Description: Group of validation messages for role module client/server both
 * Dated: 28/Nov/2019
 */

// All validations used for users module
return [
    'name' => [
        'code' => '101',
        'required' => 'Facility name is required.',
        'max' => 'Facility name may not be greater than ' . config('admin.constants.facility.name.maxLength') . ' characters.',
        'regex' => 'Facility name can consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],
    'address' => [
        'code' => '102',
        'required' => 'The address is required.',
        'max' => 'The address may not be greater than ' . config('admin.constants.address.maxLength.maxLength') . ' characters.',
    ],
    'phone_number' => [
        'code' => '103',
        'required' => 'The phone number is required.',
        'unique' => 'The phone number is already in use.',
        'regex' => 'The Phone Number Format should be (111) 223-2332 | (222)233-2332 | 232-323-3233.',
    ],
    'admin_id' => [
        'code' => '104',
        'required' => 'Please select facility admin user.',
        'exists' => 'This facility admin does not available for assignment.',
    ],
    'color_code' => [
        'code' => '105',
        'regex' => 'Enter a valid color code.',
    ],
    'logo' => [
        'code' => '106',
        'mimes' => 'Only ' . config('admin.constants.facility.logo.mimes') . ' images are allowed.',
        'size' => 'Logo size should not exceed ' . config('admin.constants.facility.logo.size') . ' kb.',
    ],
    'success' => [
        'ConfirmDelete' => 'Are you sure you want to delete this?',
    ],
    'error' => [

    ],
];
