<?php
/**
 * Author: NMG
 * Description: Group of validation messages for department module client/server both
 * Dated: 03/Dec/2019
 */

// All validations used for users module
return [
    'facility_id' => [
        'required' => 'Facility is required.',
    ],
    'name' => [
        'code' => '101',
        'required' => 'Department name is required.',
        'unique' => 'Department name is already exists.',
        'max' => 'Department name may not be greater than ' . config('admin.constants.department.name.maxLength') . ' characters.',
        'regex' => 'Department name can consists only alphabats, numbers, hyphen(-) & underscore(_).',
    ],
    'success' => [
        'ConfirmDelete' => 'Are you sure you want to delete this?',
    ],
    'error' => [

    ],
];
