<?php

/**
 * Author: Jaidev
 * Description: Group of validation messages for contact/support module client/server both
 * Dated: 14/july/2019
 */

// All validations used for contact-us module
return [
    'title' => [
        'code' => '101',
        'required' => 'Title field is required.',
        'min' => 'Title must be at least ' . config('admin.constants.contact-us.title.minLength') . ' characters.',
        'max' => 'Title may not be greater than ' . config('admin.constants.contact-us.title.maxLength') . ' characters.',
    ],
    'message' => [
        'code' => '102',
        'required' => 'The message field is required.',
        'min' => 'The message may not be less than ' . config('admin.constants.contact-us.message.minLength') . ' characters.',
        'max' => 'The message may not be greater than ' . config('admin.constants.contact-us.message.maxLength') . ' characters.',
    ],
    'success' => [
        'ConfirmDelete' => 'Are you sure you want to delete this?',
    ],
    'error' => [],
];