<?php

/**
 * Author: Jaidev
 * email : jaidev@nmgtechnologies.com
 * Description: Group of validation messages for General Setting module client/server both
 * Dated: 14/Jul/2021
 */

// All validations used for Contact Title Module
return [
    'name' => [
        'code' => '101',
        'required' => 'The Title field is required.',
        'string' => 'The Title must be a string.',
        'regex' => 'The Title Format should be String',
        'unique' => 'The Title has already been taken.',
        'exists' => 'Your Title is not created with us.',
        'min' => 'Title must be at least ' . config('admin.constants.contact-title.name.minLength') . ' characters.',
        'max' => 'Title may not be greater than ' . config('admin.constants.contact-title.name.maxLength') . ' characters.',
    ],
    'token' => [
        'code' => '113',
        'required' => 'The reset token required.',
    ],
    'success' => [
        'ConfirmDelete' => 'Are you sure you want to delete this?',
    ],
    'error' => [
        'blocked' => 'Your account has been suspended, please contact your site administrator.',
    ],
];