$(function () {
  var timeout = null;
  $('.restaurant-type-checkbox').removeAttr('checked');

  $('#nav-menu').on('click', function(){  
    $(this).data('width', 335 - $(this).data('width')); 
    $(this).data('title', ($(this).data('title') == 'X'?'Open':'X'));
    $('#mySidenav').css('width', $(this).data('width'));
    $(this).removeClass('close-btn');        
    if($(this).data('width') == 360) $(this).addClass('close-btn');
    
  });   




  
  
  /** 
   * author : jaidev
   * email : jaidev@nmgtechnologies.com
   * desc : validate change email form elements
   */
   $("#changeEmailForm").validate({
    rules: {
      old_email: {
        required: true,
        email: true
      },
      new_email: {
        required: true,
        email: true
      }
    },
    messages: {
      old_email: {
        required: "Please enter old email",
        email: "Please enter a valid email address"
      },
      new_email: {
        required : "please enter new email",
        email : "Please enter a valid email address"
      }
    },
   errorPlacement:function(error, element){
    $(".validation-error").html('');
    error.insertAfter(element);
   },
  
    submitHandler: function(form) {
      $(".validation-error").html('');

      var formdata =  $("#changeEmailForm").serialize();
      var url = $("#changeEmailForm").attr('action');
      $.ajax({
        type:"post",
        data:formdata,
        url:url,
        dataType:"json",
        success:function(resp){
          if(resp.status=='success'){
            $("#change-email-div").hide();
            $("#verify-password-div").show();
          }
          else{
            if(typeof resp.msg === 'string'){
              alert("Error : " + resp.msg);
            }
            else{
              var errors = resp.msg;
              $.each(errors , function(key , val){
                $("#" + key + "_error").text(val[0]);
              });
            }
          }
        },
        error:function(){
          alert('Access Denied');
        }
      });
    }
  });



  /** 
   * author : jaidev
   * email : jaidev@nmgtechnologies.com
   * method : validateCurrentPasswordForm
   * desc : validate user's current password and send otp to change email 
   * create : 12/jul/2021
   * update : 12/jul/2021
   */

   $("#validateCurrentPasswordForm").validate({
    rules: {
      password: {
        required: true,
        maxlength:'16',
        minlength:'8'
      }
    },
    messages: {
      password: {
        required: "Please enter password",
        maxlength: "The password may not be greater than 16 characters",
        minlength: "The password may not be less than 8 characters",
        regex: "Please enter a valid password",
      }
    },
    errorPlacement:function(error, element){
      $(".validation-error").html('');
      error.insertAfter(element);
     },
    submitHandler: function(form) {
      $(".validation-error").html('');
      var formdata =  $("#validateCurrentPasswordForm").serialize();
      var url = $("#validateCurrentPasswordForm").attr('action');
      // alert(url); return false;

      $.ajax({
        type:"post",
        data:formdata,
        url:url,
        dataType:"json",
        success:function(resp){
          if(resp.status=='success'){
            $("#verify-password-div").hide();
            $("#verify-otp-div").show();
            $("#remaining-div-change-email").show();
            $("#remaining-time-change-email").show();
            clearTimeout(timeout);
            startCounterTime(60 , 'remaining-time-change-email');
          }
          else{
            if(typeof resp.msg === 'string'){
              alert("Error : " + resp.msg);
            }
            else{
              var errors = resp.msg;
              $.each(errors , function(key , val){
                $("#" + key + "_error").text(val[0]);
              });
            }
          }
        },
        error:function(){
          alert('Access Denied');
        }
      });
    }
  });

/** 
   * author : jaidev
   * email : jaidev@nmgtechnologies.com
   * method : verifyOtpFormEmailChange
   * desc : verify last otp send to user's email id 
   * create : 12/jul/2021
   * update : 12/jul/2021
   */


  
  $("#verifyOtpFormEmailChange").validate({
    rules: {
      otp: {
        required: true,
        exactlength:'1',
      }
    },
    messages: {
      otp: {
        required: "required",
        exactlength: "Please Enter only 1 digit in box",
      }
    },

    errorPlacement: function(error, element) {
      
      $("#otp_error").html("Please enter otp");
  },
  
    submitHandler: function(form) {
      $(".validation-error").html('');
      var formdata =  $("#verifyOtpFormEmailChange").serialize();
      var url = $("#verifyOtpFormEmailChange").attr('action');
      $.ajax({
        type:"post",
        data:formdata,
        url:url,
        dataType:"json",
        success:function(resp){
          if(resp.status=='success'){
            $("#verify-otp-div").hide();
            $("#change-email").modal('hide');
            $("#change-email-div").show();
            $("#change-email-success-modal").modal('show');
          }
          else{
            if(typeof resp.msg === 'string'){
              alert("Error : " + resp.msg);
            }
            else{
              var errors = resp.msg;
              $.each(errors , function(key , val){
                $("#" + key + "_error").text(val[0]);
              });
            }
          }
        },
        error:function(){
          alert('Access Denied');
        }
      });
    }
  });




  /** 
   * Change Phone Number Modal Form
   * jaidev
   * jaidev@nmgtechnologies.com
   * 12/jul/2021
   */

  
  /** 
   * author : jaidev
   * email : jaidev@nmgtechnologies.com
   * desc : validate change mobile no form elements
   */
   $("#changePhoneNumberForm").validate({
    rules: {
      old_number: {
        required: true,
        maxlength:10
      },
      new_number: {
        required: true,
        maxlength:10
      }
    },
    messages: {
      old_number: {
        required: "Please enter old phone number",
        maxlength: "Please enter 10 digits"
      },
      new_number: {
        required: "Please enter new phone number",
        maxlength: "Please enter 10 digits"
      }
    },
    errorPlacement:function(error, element){
      $(".validation-error").html('');
      error.insertAfter(element);
     },
    submitHandler: function(form) {
      $(".validation-error").html('');

      var formdata =  $("#changePhoneNumberForm").serialize();
      var url = $("#changePhoneNumberForm").attr('action');
      $.ajax({
        type:"post",
        data:formdata,
        url:url,
        dataType:"json",
        success:function(resp){
          if(resp.status=='success'){
            $("#change-phone-div").hide();
            $("#verify-phone-otp-div").show();

            // remaining-time-sms-otp
            // clearTimeout(timeout);
            startCounterTime(60 , 'remaining-time-sms-otp');
          }
          else{
            if(typeof resp.msg === 'string'){
              alert("Error : " + resp.msg);
            }
            else{
              var errors = resp.msg;
              $.each(errors , function(key , val){
                $("#" + key + "_error").text(val[0]);
              });
            }
          }
        },
        error:function(){
          alert('Access Denied');
        }
      });
    }
  });



 
/** 
   * author : jaidev
   * email : jaidev@nmgtechnologies.com
   * method : verificationCode
   * desc : verify last otp send to user's phone number 
   * create : 18/aug/2021
   * update : 18/aug/2021
   */
  
 $("#verificationCode").validate({
  rules: {
    otp: {
      required: true,
      exactlength:'1',
    }
  },
  messages: {
    otp: {
      required: "Please enter otp",
      exactlength: "Please Enter only 1 digit in box",
    }
  },
  errorPlacement: function(error, element) {
    $("#otp_error").html("Please enter otp");
},

  submitHandler: function(form) {
    form.submit();
  }
});


  
/** 
   * author : jaidev
   * email : jaidev@nmgtechnologies.com
   * method : verifyOtpNumberForm
   * desc : verify last otp send to user's phone number 
   * create : 12/jul/2021
   * update : 12/jul/2021
   */
  
 $("#verifyOtpNumberForm").validate({
  rules: {
    otp: {
      required: true,
      exactlength:'1',
    }
  },
  messages: {
    otp: {
      required: "Please enter otp",
      exactlength: "Please Enter only 1 digit in box",
    }
  },
  errorPlacement: function(error, element) {
      
    $("#sms_otp_error").html("Please enter otp");
},

  submitHandler: function(form) {
    $(".validation-error").html('');
    var formdata =  $("#verifyOtpNumberForm").serialize();
    var url = $("#verifyOtpNumberForm").attr('action');
    $.ajax({
      type:"post",
      data:formdata,
      url:url,
      dataType:"json",
      success:function(resp){
        if(resp.status=='success'){
          $("#verify-phone-otp-div").hide();
          $("#change-phone-number").modal('hide');
          $("#change-phone-div").show();
          $("#change-phone-no-success-modal").modal('show');
        }
        else{
          if(typeof resp.msg === 'string'){
            alert("Error : " + resp.msg);
          }
          else{
            var errors = resp.msg;
            $.each(errors , function(key , val){
              $("#" + key + "_error").text(val[0]);
            });
          }
        }
      },
      error:function(){
        alert('Access Denied');
      }
    });
  }
});



/** 
   * author : jaidev
   * email : jaidev@nmgtechnologies.com
   * desc : validate contact us form elements
   */
 $("#contactForm").validate({
  rules: {
    title_id: {
      required: true,
      
    },
    message: {
      required: true,
      maxlength: 400
    }
  },
  messages: {
    title_id: {
      required: "Title field is required",
    },
    message: {
      required : "Message field is required",
      maxlength : "Message may not be greater than 255 characters"
    }
  },
  errorPlacement:function(error, element){
    $(".validation-error").html('');
    error.insertAfter(element);
   },
  submitHandler: function(form) {
   form.submit();
  // alert();
  }
});





// changeb password form 
$("#changePassword").validate({
  rules: {
      password: {
        required: true,
        minlength: 8,
        maxlength: 16,
        regex: "^(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9]).*$",
      },
      new_password: {
        required: true,
        minlength: 8,
        maxlength: 16,
        regex: "^(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9]).*$",
      },
      new_password_confirmation: {
        required: true,
        minlength: 8,
        maxlength: 16,
        regex: "^(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9]).*$",
        equalTo: "#new_password"
      }
  },
  messages: {
    password: {
      code: "106",
      required: "The password field is required.",
      min: "The password must be at least 8 characters.",
      max: "The password may not be greater than 16 characters.",
      regex: "The password should have consist with at least one uppercase, one lowercase, one special charecter &amp; a number.",
  },

  new_password: {
      code: "108",
      required: "The new password field is required.",
      minlength: "The new password must be at least 8 characters.",
      maxlength: "The new password may not be greater than 16 characters.",
      regex: "The new password should have consist with at least one uppercase, one lowercase, one special charecter &amp; a number.",
  },
  new_password_confirmation: {
      code: "109",
      required: "The confirm new password field is required.",
      minlength: "The new password must be at least 8 characters.",
      maxlength: "The new password may not be greater than 16 characters.",
      regex: "The new password should have consist with at least one uppercase, one lowercase, one special charecter &amp; a number.",
      equalTo: "Confirm new password must be same as new password.",
  },
  },
  errorPlacement:function(error, element){
    $(".validation-error").html('');
    error.insertAfter(element);
   },
  submitHandler: function(form) {
    // form.submit();
   // alert();
   $(".validation-error").html('');
   var formdata =  $("#changePassword").serialize();
   var url = $("#changePassword").attr('action');
   $("#submit-btn").attr('disabled' , true);
   $.ajax({
     type:"post",
     data:formdata,
     url:url,
     dataType:"json",
     success:function(resp){
      $("#submit-btn").attr('disabled' , false);
       if(resp.status=='success'){
         $("#password-changed").modal('show');
       }
       else{
         if(typeof resp.msg === 'string'){
           alert("Error : " + resp.msg);
         }
         else{
           var errors = resp.msg;
           $.each(errors , function(key , val){
             $("#" + key + "_error").text(val[0]);
           });
         }
       }
     },
     error:function(){
      $("#submit-btn").attr('disabled' , false);
       alert('Access Denied');
     }
   });
   }
});


$.validator.addMethod('regex', function(value, element, param) {
  return this.optional(element) ||
      value.match(typeof param == 'string' ? new RegExp(param) : param);
},
'Please enter a value in the correct format.');

}); // end load func



/** 
 * author : bibhash
 * email : bibhash.shisodiya@nmgtechnologies.com
 * desc : Count Remaining Time
 * create : 16/jul/2021
 * update : 16/jul/2021
 */

function startTimer(duration, display) {
  // alert(display);
    var timer = duration,
        minutes, seconds;
     setInterval(function() {
        minutes = parseInt(timer / 60, 10);
        seconds = parseInt(timer % 60, 10);
        //stopTimer =0;

        minutes = minutes < 10 ? "0" + minutes : minutes;
        seconds = seconds < 10 ? "0" + seconds : seconds;

        display.textContent = minutes + ":" + seconds;
        sessionStorage.setItem('timeCount', minutes * 60 + parseInt(seconds));
        //console.log(minutes*60+parseInt(seconds));
        if (--timer < 0) {
            // Store
            sessionStorage.setItem("stopTimer", 1);

            timer = duration;
            $("#verifynow").css("display", "none");
            $("#resendOtp").show();
            $("#remaining-div").css("display", "none");
        }

    }, 1000);
}

/**
 * Author : Jaidev
 * Method : startCounterTime
 * Desc : timer counter to put on any element with given id 
 */
  var timeout;
  function startCounterTime(duration, elementId) {
    clearInterval(timeout);
    var display = document.querySelector('#'+elementId);
    var timer = duration;
    var minutes;
    var seconds;
    var timeout = null;
    timeout = setInterval(function () {
        minutes = parseInt(timer / 60, 10);
        seconds = parseInt(timer % 60, 10);
  
        minutes = minutes < 10 ? "0" + minutes : minutes;
        seconds = seconds < 10 ? "0" + seconds : seconds;
  
        display.textContent = minutes + ":" + seconds;
      //  sessionStorage.setItem('lastname',minutes*60+parseInt(seconds));
        //console.log(minutes*60+parseInt(seconds));
        if (--timer < 0) {
            timer = duration;
  
            if(elementId=='remaining-time-sms-otp'){
              $("#remaining-div-sms").hide();
              $("#verify-sms-otp-btn").hide();
              $("#resent-sms-otp-btn").show();
            }
  
            if(elementId=='remaining-time-change-email'){
              $("#remaining-div-change-email").hide();
              $("#verify-otp-btn").hide();
              $("#resent-otp-btn").show();
            }
            clearTimeout(timeout);
        }
    }, 1000);
  }



// window.onload = function() {
    
//     if (sessionStorage.getItem('stopTimer')) {
//         $("#verifynow").css("display", "none");
//         $("#resendOtp").show();
//         $("#remaining-div").css("display", "none");
//     } else {
//         $("#resendOtp").hide();
//     }

//     if(sessionStorage.getItem('timeCount')){
//         //console.log("data+"+sessionStorage.getItem('timeCount'));
//        var fiveMinutes =sessionStorage.getItem('timeCount');
//        sessionStorage.removeItem('timeCount');
//     }else{
//       var fiveMinutes =60 * 1;
//     }

//     display = document.querySelector('#remaining-time');
//     startTimer(fiveMinutes, display);
// };

/** 
 * author : jaidev
 * email : jaidev@nmgtechnologies.com
 * desc : Resend OTP on SMS
 * create : 12/jul/2021
 * update : 12/jul/2021
 */
$(document).on('click' , '#resent-sms-otp-btn' , function(){
  var baseUrl = $(this).attr('data-url');
  var _token = $('meta[name="csrf-token"]').attr("content");
  $.ajax({
    url: baseUrl+'/resend-sms-otp',
    type: "post",
    data: {
        _token: _token
    },
    success: function(data) {
        if (data.status=='success') {
          $("#verify-sms-otp-btn").show();
          $("#resent-sms-otp-btn").hide();
          clearTimeout(timeout);
          startCounterTime(60 , 'remaining-time-sms-otp');
          $("#remaining-div-sms").show();
        }
        else{
          alert(data.msg);
        }
    },
    error: function(xhr, status, error) {
        alert("Access denined");
    }
});
});


/** 
 * author : jaidev
 * email : jaidev@nmgtechnologies.com
 * desc : Resend OTP on Mail
 * create : 12/jul/2021
 * update : 12/jul/2021
 */
 $(document).on('click' , '#resent-otp-btn' , function(){
  var baseUrl = $(this).attr('data-url');
  var _token = $('meta[name="csrf-token"]').attr("content");
  clearTimeout(timeout);
  $.ajax({
    url: baseUrl+'/resend-otp',
    type: "post",
    data: {
        _token: _token
    },
    success: function(data) {
        if (data.status=='success') {
          $("#verify-otp-btn").show();
          $("#resent-otp-btn").hide();
          clearTimeout(timeout);
          startCounterTime(60 , 'remaining-time-change-email');
          $("#remaining-div-change-email").show();
        }
        else{
          alert(data.msg);
        }
    },
    error: function(xhr, status, error) {
        alert("Access denined");
    }
});
});

$(".profileChangeEmail").hide();


$(document).on('click' , '#nav-menu' , function(){
  $('.sidenav').toggleClass('menu-collapse');
  $('#body-container').toggleClass('slide-right');
});


// $('#nav-menu').click(function() {
// 	$('.sidenav').toggleClass('menu-collapse');
// });
// $('#nav-menu').click(function() {
// 	$('#body-container').toggleClass('slide-right');
// });


  $('#mob-nav-icon').click(function(){
     $(this).toggleClass('open');
});

$("#mob-nav-icon").click(function () {
    $(".sidenav").toggleClass("menu-slide");
});
    
$(document).on('click' , '.sidenav ul li a.arrow' , function(){

  if($(this).next("ul").is(":visible")){
        $(this).next("ul").slideUp("fast");
        $(this).parent().removeClass("selected");
    }

    else{
        $(".sidenav ul li a.arrow").next("ul").slideUp("fast");
        $(this).next("ul").slideDown("fast");

        $(".sidenav ul li a.arrow").parent().removeClass("selected");
        $(this).parent().addClass("selected");
    }
});
// $(".sidenav ul li a.arrow").click(function(){    

// 	if($(this).next("ul").is(":visible")){
// 		$(this).next("ul").slideUp("fast");
// 		$(this).parent().removeClass("selected");
// 	}

// 	else{
// 		$(".sidenav ul li a.arrow").next("ul").slideUp("fast");
// 		$(this).next("ul").slideDown("fast");

// 		$(".sidenav ul li a.arrow").parent().removeClass("selected");
// 		$(this).parent().addClass("selected");
// 	}
// });


$(".sidenav ul li ul a.active").each(function(){
  $("ul.submenu").slideDown("fast");
  $("ul.submenu").parent("li").addClass("selected");

})


$(document).on('change' , '.change-restaurant-menu-status' , function(){
  var id = $(this).attr('data');
  var baseUrl = $(this).attr('baseurl');
  var _token = $('meta[name="csrf-token"]').attr("content");
  $.ajax({
    url: baseUrl,
    type: "get",
    data: {
        _token: _token,
        id: id
    },
    success: function(data) {
        if (data.success) {
            $("#switch-btn-"+data.id).html(data.changeStatus.status);
        }
    },
    error: function(xhr, status, error) {
        alert("Access denined");
    }
});
});

$("#upload-photo").change(function(){
  //imagePreview(this);
  
  iSize = this.files[0].size/ 1024;
  imgSize = Math.round((iSize / 1024) * 100) / 100;
  // alert(imgSize);
  if(imgSize > 5)
  {
    // return false;
      // $('#img-error').html('Image should be less than 5 MB.');
  }
  else
  {			
      imagePreview(this);	
  }
});

function imagePreview(input)
{
$('#img-error').html('');
   if(input.files && input.files[0])
  {
      var reader = new FileReader();

      reader.onload = function (e) {
          $('#imagePreview').attr('src', e.target.result);
      };

      reader.readAsDataURL(input.files[0]);
  }       
}

/* 
* @author : jaidev
* @email : jaidev@nmgtechnologies.com
* created at : 7/jul/2021
* updated at : 7/jul/2021
* desc : count remaining character of input/textarea element   
*/

$(document).on('keyup' , '.character-counter' , function(){
  var ele = $(this);
  var counterDiv = $(ele).attr('data-counter-div');
  var maxlength = $(ele).attr('maxlength');
  var enteredChar = $(ele).val().length;
  $("#"+counterDiv).html(enteredChar+'/'+maxlength+' characters');
});

// check restaurant type // edit profile

$(document).on('click' , '#restaurantEditProfile' , function(){
      var local = jQuery("input[name='type[local]']:checked").length;
      var continental = jQuery("input[name='type[continental]']:checked").length;
      var groceries = jQuery("input[name='type[groceries]']:checked").length;
      if(!local && !continental && !groceries) {
        $('#restaurant-type-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">The restaurant type field is required</label>');
        jQuery("#local").focus();
        return false;
      }
      else{
        $('#restaurant-type-error').html('');
      }

});




jQuery(document).ready(function () {

    jQuery('#restaurantUpd').click(function() {
      //var checked = jQuery("input[type=checkbox]:checked").length;
      var local = jQuery("input[name='local']:checked").length;
      var continental = jQuery("input[name='continental']:checked").length;
      var groceries = jQuery("input[name='groceries']:checked").length;
      if(!local && !continental && !groceries) {
        $('#restaurant-type-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">The restaurant type field is required</label>');
        return false;
      }
      else{
        $('#restaurant-type-error').html('');
      }

      var termcondition = jQuery("input[name='termcondition']:checked").length;

      var latitude  = jQuery('input[name="latitude"]').val();
      var longitude = jQuery('input[name="longitude"]').val();

      

      if(!termcondition) {
        $('#termcondition-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">You must agree with the terms and conditions.</label>');
        return false;
      }
      else{
        $('#termcondition-error').html('');
      }
      
      if(!latitude || !longitude) {
         $('#address-web-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">The Address1 field is required for autosuggestion.</label>');
         $("#address1").focus();
        return false;
      }
      else{
        $('#address-web-error').html('');
      }
      

      // if(!longitude) {
      //   $('#address-web-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">The Address1 field is required for autosuggestion.</label>');
      //   return false;
      // }

    });
});


//Send otp Verification.




$(document).on('keyup' , '.otp-input' , function(e){
  var tab = $(this).attr("tabindex");
  var val = $(this).val();
  if(val.length > 1){
    $(this).val(String(val).charAt(0));
  }

  if(e.keyCode==8){
    tab--;
    $("[tabindex='"+tab+"']").focus();
  }
  else{
    tab++;
    if (this.value.length == this.maxLength) {
      $("[tabindex='"+tab+"']").focus();
    }
  }
});

$(document).on('click' , '.clear-validation' , function(){
  $(".validation-error").html('');
});

$(document).on('keyup' , '.form-control, .input-field' , function(){
  $(this).valid();
});



$(document).on('change' , '.order-filter' , function(){
  var status = $(this).val();
  var baseUrl = $(this).attr('data-url');
  
  var url = baseUrl+'?type=punched&status='+status;
  window.location = url;
  return false;
});


/** 
 * author: bibhash
 * email : bibhash.shisodiya@nmgtechnologies.com
 * method : validateCurrentPasswordForm
 * desc : offline and online food discovery and delivery facilitated by restaurant.
 * create : 25/Aug/2021
 * update : 25/Aug/2021
 */

$(document).on('change' , '.rstOnOffLine' , function(){
 var getUrl = window.location.href;
 var baseUrl = getUrl+ "/online-offline-restaurant";
 $.ajax({
      url: baseUrl,
      type: "get",
      success: function(data) {
        if (data.success){
          $(".status").html(data.success.status);
        }
      },
      error: function(xhr, status, error) {
          alert("Access denined");
      }
  });
});

// var codeCharInput = 'input.otp-input';
// $(codeCharInput+':first').focus();
// $(codeCharInput).keyup(function(e) {
//   if ((e.which == 8 || e.which == 46)) {
//     $(this).prev(codeCharInput).focus().val($(this).prev().val());
//   } else {
//     if (this.value.length == this.maxLength) {
//       $(this).next(codeCharInput).focus();
//     }
//   }
// });
