/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility-users.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (formId == "forgotPassword") {
        $("#forgotPassword").validate({
            ignore: [],
            rules: {
                email: {
                    required: true,
                    maxlength: objValConst.email.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                }
            },
            messages: {
                email: {
                    required: objValMsgConst.email.required,
                    maxlength: objValMsgConst.email.max,
                    email: objValMsgConst.email.email
                }
            }
        });
    } else if (formId == "loginForm") {
        //alert("loginForm");
        $("#loginForm").validate({
            ignore: [],
            rules: {
                email: {
                    required: true,
                    maxlength: objValConst.email.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                password: {
                    required: true,
                    minlength: objValConst.password.minLength,
                    maxlength: objValConst.password.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                }
            },
            messages: {
                email: {
                    required: objValMsgConst.email.required,
                    maxlength: objValMsgConst.email.max,
                    email: objValMsgConst.email.email
                },
                password: {
                    required: objValMsgConst.password.required,
                    minlength: objValMsgConst.password.min,
                    maxlength: objValMsgConst.password.max
                }
            }
        });

    } else if (formId == "signup") { 
        //alert("signup");
        $("#signup").validate({
            ignore: [],
            rules: {
                name: {
                    required: true,
                    maxlength: objValConst.name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                bio: {
                    required: true,
                    maxlength: objValConst.bio.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                email: {
                    required: true,
                    maxlength: objValConst.email.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                phone_number: {
                    required: true,
                    minlength: objValConst.phone_number.minLength,
                    maxlength: objValConst.phone_number.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //phoneRegExp:objValConst.phone_number.regex,
                },
                address2: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                locality: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                country: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                password: {
                    required: true,
                    minlength: objValConst.password.minLength,
                    maxlength: objValConst.password.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    passwordValidator1: true,
                },
                password_confirmation: {
                    required: true,
                    equalTo: "#password"
                }
                // termcondition: {
                //     required: true,
                //     normalizer: function(value) {
                //         return $.trim(value);
                //     },
                // }
            },
            messages: {
                name: {
                    required: objValMsgConst.name.required,
                    maxlength: objValMsgConst.name.max,
                },
                bio: {
                    required: objValMsgConst.bio.required,
                    maxlength: objValMsgConst.bio.max,
                },
                email: {
                    required: objValMsgConst.email.required,
                    maxlength: objValMsgConst.email.max,
                    email: objValMsgConst.email.email
                },
                phone_number: {
                    required: objValMsgConst.phone_number.required,
                    minlength: objValMsgConst.phone_number.min,
                    maxlength: objValMsgConst.phone_number.max,
                    phoneRegExp: objValMsgConst.phone_number.regex

                },
                address2: {
                    required: objValMsgConst.address2.required,
                },
                locality: {
                    required: objValMsgConst.city.required,
                },
                country: {
                    required: objValMsgConst.country.required,
                },
                password: {
                    required: objValMsgConst.password.required,
                    minlength: objValMsgConst.password.min,
                    maxlength: objValMsgConst.password.max,
                    passwordRegEx: objValMsgConst.password.regex
                },
                password_confirmation: {
                    required: objValMsgConst.password_confirmation.required,
                    equalTo: objValMsgConst.password_confirmation.equalTo
                },
                termcondition: {
                    required: objValMsgConst.termcondition.required,
                }
            },

            errorPlacement:function(error, element){
				
				if(element.attr("name") == "phone_number"){
                    error.insertAfter(element.parent());
                    $(element).parent('div').addClass('error');
                    $(element).removeClass('error');
                }
                else{
                    error.insertAfter(element);
                }
			},
        });

    } 
    else if (formId == "editRestaurant") { 
        //alert("signup");
        $("#signup").validate({
            ignore: [],
            rules: {
                name: {
                    required: true,
                    maxlength: objValConst.name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                bio: {
                    required: true,
                    maxlength: objValConst.bio.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                email: {
                    required: true,
                    maxlength: objValConst.email.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                phone_number: {
                    required: true,
                    minlength: objValConst.phone_number.minLength,
                    maxlength: objValConst.phone_number.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //phoneRegExp:objValConst.phone_number.regex,
                },
                address2: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                locality: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                country: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                password: {
                    required: true,
                    minlength: objValConst.password.minLength,
                    maxlength: objValConst.password.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    passwordValidator: true,
                },
                password_confirmation: {
                    required: true,
                    equalTo: "#password"
                }
                // termcondition: {
                //     required: true,
                //     normalizer: function(value) {
                //         return $.trim(value);
                //     },
                // }
            },
            messages: {
                name: {
                    required: objValMsgConst.name.required,
                    maxlength: objValMsgConst.name.max,
                },
                bio: {
                    required: objValMsgConst.bio.required,
                    maxlength: objValMsgConst.bio.max,
                },
                email: {
                    required: objValMsgConst.email.required,
                    maxlength: objValMsgConst.email.max,
                    email: objValMsgConst.email.email
                },
                phone_number: {
                    required: objValMsgConst.phone_number.required,
                    minlength: objValMsgConst.phone_number.min,
                    maxlength: objValMsgConst.phone_number.max,
                    phoneRegExp: objValMsgConst.phone_number.regex

                },
                address2: {
                    required: objValMsgConst.address2.required,
                },
                locality: {
                    required: objValMsgConst.city.required,
                },
                country: {
                    required: objValMsgConst.country.required,
                },
                password: {
                    required: objValMsgConst.password.required,
                    minlength: objValMsgConst.password.min,
                    maxlength: objValMsgConst.password.max,
                    passwordRegEx: objValMsgConst.password.regex
                },
                password_confirmation: {
                    required: objValMsgConst.password_confirmation.required,
                    equalTo: objValMsgConst.password_confirmation.equalTo
                },
                termcondition: {
                    required: objValMsgConst.termcondition.required,
                }
            }
        });

    }
    else if (formId == "createTax") {
        //alert("loginForm");
        $("#createTax").validate({
            ignore: [],
            rules: {
                tax: {
                    required: true,
                    minlength: objValConst.tax.minLength,
                    maxlength: objValConst.tax.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    taxRegExp:objValConst.tax.regex,
                }
            },
            messages: {

                tax: {
                    required: objValMsgConst.tax.required,
                    minlength: objValMsgConst.tax.min,
                    maxlength: objValMsgConst.tax.max,
                    taxRegExp: objValMsgConst.tax.regex
                },
            },
        });
    }
    else if (formId == "changePassword") {
        //alert(formId);
        $("#changePassword").validate({
            ignore: [],
            rules: {
                password: {
                    required: true
                },
                new_password: {
                    required: true,
                    minlength: objValConst.password.minLength,
                    maxlength: objValConst.password.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //passwordRegEx: objValConst.password.regex
                    passwordValidator: true,
                },
                new_password_confirmation: {
                    required: true,
                    equalTo: "#new_password"
                }
            },
            messages: {
                password: {
                    required: objValMsgConst.password.required,
                    minlength: objValMsgConst.password.min,
                    maxlength: objValMsgConst.password.max
                },
                new_password: {
                    required: objValMsgConst.new_password.required,
                    minlength: objValMsgConst.new_password.min,
                    maxlength: objValMsgConst.new_password.max,
                    passwordRegEx: objValMsgConst.new_password.regex
                },
                new_password_confirmation: {
                    required: objValMsgConst.new_password_confirmation.required,
                    equalTo: objValMsgConst.new_password_confirmation.equalTo
                }
            }
        });
    } else if (formId == "resetPasswordForm") {
        //alert(formId);
        $("#resetPasswordForm").validate({
            ignore: [],
            rules: {
                email: {
                    required: true,
                    maxlength: objValConst.email.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                new_password: {
                    required: true,
                    minlength: objValConst.new_password.minLength,
                    maxlength: objValConst.new_password.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //passwordRegEx: objValConst.new_password.regex
                    passwordValidator: true,
                },
                new_password_confirmation: {
                    required: true,
                    equalTo: "#new_password"
                }
            },
            messages: {
                email: {
                    required: objValMsgConst.email.required,
                    maxlength: objValMsgConst.email.max,
                    email: objValMsgConst.email.email
                },
                new_password: {
                    required: objValMsgConst.new_password.required,
                    minlength: objValMsgConst.new_password.min,
                    maxlength: objValMsgConst.new_password.max,
                    passwordRegEx: objValMsgConst.new_password.regex
                },
                new_password_confirmation: {
                    required: objValMsgConst.new_password_confirmation.required,
                    equalTo: objValMsgConst.new_password_confirmation.equalTo
                }
            }
        });
    } else if(formId == "restaurantResetPassword") {
        //alert(formId);
        $("#restaurantResetPassword").validate({
            ignore: [],
            rules: {
                email: {
                    required: true,
                    maxlength: objValConst.email.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                otp: {
                    required: true,
                    minlength: objValConst.otp.minLength,
                    maxlength: objValConst.otp.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                new_password: {
                    required: true,
                    minlength: objValConst.new_password.minLength,
                    maxlength: objValConst.new_password.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //passwordRegEx: objValConst.new_password.regex
                    passwordValidator: true,
                },
                new_password_confirmation: {
                    required: true,
                    equalTo: "#new_password"
                }
            },
            messages: {
                email: {
                    required: objValMsgConst.email.required,
                    maxlength: objValMsgConst.email.max,
                    email: objValMsgConst.email.email
                },
                otp: {
                    required: objValMsgConst.otp.required,
                    maxlength: objValMsgConst.otp.max,
                    minlength: objValMsgConst.otp.min,
                },
                new_password: {
                    required: objValMsgConst.new_password.required,
                    minlength: objValMsgConst.new_password.min,
                    maxlength: objValMsgConst.new_password.max,
                    passwordRegEx: objValMsgConst.new_password.regex
                },
                new_password_confirmation: {
                    required: objValMsgConst.new_password_confirmation.required,
                    equalTo: objValMsgConst.new_password_confirmation.equalTo
                }
            }
        });
     } else if(formId == "profileEditForm") {
        //alert(formId);
        $("#profileEditForm").validate({
            ignore: [],
            rules: {
                first_name: {
                    required: true,
                    minlength: objValConst.first_name.minLength,
                    maxlength: objValConst.first_name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //fNameRegEx: objValConst.first_name.regex
                },
                last_name: {
                    required: true,
                    minlength: objValConst.last_name.minLength,
                    maxlength: objValConst.last_name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //lNameRegEx: objValConst.last_name.regex
                },
                avatar: {
                    accept: "jpeg,jpg,png",
                    extension: "jpeg,jpg,png,gif"
                }
            },
            messages: {
                first_name: {
                    required: objValMsgConst.first_name.required,
                    minlength: objValMsgConst.first_name.min,
                    maxlength: objValMsgConst.first_name.max,
                    fNameRegEx: objValMsgConst.first_name.regex
                },
                last_name: {
                    required: objValMsgConst.last_name.required,
                    minlength: objValMsgConst.last_name.min,
                    maxlength: objValMsgConst.last_name.max,
                    lNameRegEx: objValMsgConst.last_name.regex
                },
                avatar: {
                    filesize: objValMsgConst.avatar.filesize,
                    extension: objValMsgConst.avatar.mimes,
                    accept: objValMsgConst.avatar.mimes
                }
            }
        });
    } else if (formId == "createUser") {
        //alert('svwf');
        $("#createUser").validate({
            ignore: [],
            rules: {
                role_id: {
                    required: true
                },
                facility_id: {
                    //required: true
                },
                department_id: {
                    required: true
                },
                title_id: {
                    required: true
                },
                user_name: {
                    required: true,
                    minlength: objValConst.user_name.minLength,
                    maxlength: objValConst.user_name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    userNameRegExp: objValConst.user_name.regex
                },
                email: {
                    required: true,
                    minlength: objValConst.email.minLength,
                    maxlength: objValConst.email.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                phone_number: {
                    minlength: objValConst.phone_number.minLength,
                    maxlength: objValConst.phone_number.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //phoneRegExp:objValConst.phone_number.regex,
                },
                mobile_no: {
                    required: true,
                    minlength: objValConst.mobile_no.minLength,
                    maxlength: objValConst.mobile_no.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    mobileRegExp:objValConst.mobile_no.regex,
                },
                password: {
                    required: true,
                    minlength: objValConst.password.minLength,
                    maxlength: objValConst.password.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    passwordRegEx: objValConst.password.regex
                },
                confirm_password: {
                    required: true,
                    equalTo: "#passwords",
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },

                first_name: {
                    required: true,
                    minlength: objValConst.first_name.minLength,
                    maxlength: objValConst.first_name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //fNameRegEx: objValConst.first_name.regex
                },
                last_name: {
                    required: true,
                    minlength: objValConst.last_name.minLength,
                    maxlength: objValConst.last_name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //lNameRegEx: objValConst.last_name.regex
                },
                avatar: {
                    accept: "jpeg,jpg,png",
                    extension: "jpeg,jpg,png,gif"
                },
                role_id: {
                    required: true
                }
            },
            messages: {
                role_id: {
                    required: objValMsgConst.role_id.required
                },
                facility_id: {
                    required: objValMsgConst.facility_id.required
                },
                department_id: {
                    required: objValMsgConst.department_id.required
                },
                title_id: {
                    required: objValMsgConst.title_id.required
                },
                user_name: {
                    required: objValMsgConst.user_name.required,
                    minlength: objValMsgConst.user_name.min,
                    maxlength: objValMsgConst.user_name.max,
                    userNameRegExp: objValMsgConst.user_name.regex
                },
                email: {
                    required: objValMsgConst.email.required,
                    minlength: objValMsgConst.email.min,
                    maxlength: objValMsgConst.email.max,
                    email: objValMsgConst.email.email,
                    emailRegExp: objValMsgConst.email.regex
                },
                phone_number: {
                    minlength: objValMsgConst.phone_number.min,
                    maxlength: objValMsgConst.phone_number.max,
                    phoneRegExp: objValMsgConst.phone_number.regex

                },
                mobile_no: {
                    required: objValMsgConst.mobile_no.required,
                    minlength: objValMsgConst.mobile_no.min,
                    maxlength: objValMsgConst.mobile_no.max,
                    mobileRegExp: objValMsgConst.mobile_no.regex

                },

                password: {
                    required: objValMsgConst.password.required,
                    minlength: objValMsgConst.password.min,
                    maxlength: objValMsgConst.password.max,
                    passwordRegEx: objValMsgConst.password.regex
                },
                confirm_password: {
                    required: objValMsgConst.confirm_password.required,
                    equalTo: objValMsgConst.confirm_password.equalTo
                },
                first_name: {
                    required: objValMsgConst.first_name.required,
                    minlength: objValMsgConst.first_name.min,
                    maxlength: objValMsgConst.first_name.max,
                    fNameRegEx: objValMsgConst.first_name.regex
                },
                last_name: {
                    required: objValMsgConst.last_name.required,
                    minlength: objValMsgConst.last_name.min,
                    maxlength: objValMsgConst.last_name.max,
                    lNameRegEx: objValMsgConst.last_name.regex
                },
                avatar: {
                    filesize: objValMsgConst.avatar.filesize,
                    extension: objValMsgConst.avatar.mimes,
                    accept: objValMsgConst.avatar.mimes
                }
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }
    
    // password validation for special condition.
     $.validator.addMethod("passwordValidator", function(value, element) {
        // allow  atleast 1 number, 1 uppercase, 1 lowercase and 1 special character(@#$%^&)
        return this.optional(element) || /^((?=.*\d)(?=.*[A-Z])(?=.*\W).{8,15})$/
            .test(value);
     },
      'The new password should have consist with at least one number, one uppercase, one lowercase, one special character(@#$%^&) required.'
    );


     // password validation for special condition.
     $.validator.addMethod("passwordValidator1", function(value, element) {
        // allow  atleast 1 number, 1 uppercase, 1 lowercase and 1 special character(@#$%^&)
        return this.optional(element) || /^((?=.*\d)(?=.*[A-Z])(?=.*\W).{8,15})$/
            .test(value);
     },
      'The password should have consist with at least one number, one uppercase, one lowercase, one special character(@#$%^&) required.'
    );

    $.validator.addMethod(
        "userNameRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.user_name.regex
    );

    $.validator.addMethod(
        "mobileRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.mobile_no.regex
    );

    $.validator.addMethod(
        "phoneRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.phone_number.regex
    );



    $.validator.addMethod(
        "passwordRegEx",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.confirm_password.regex
    );



    $.validator.addMethod(
        "lNameRegEx",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.last_name.regex
    );

    $.validator.addMethod("customemail",
            function (value, element) {
                return this.optional(element) || /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/.test(value);
            },
            "Please enter valid email address"
    );
})(jQuery);
