/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (typeof formId !== "undefined" && formId == "titleForm") {
        $("#titleForm").validate({
            ignore: [],
            rules: {
                facility_id: {
                    required: true,
                },
                name: {
                    required: true,
                    maxlength: objValConst.name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //nameRegExp: objValConst.name.regex
                }
            },
            messages: {
                facility_id: {
                    required: objValMsgConst.facility_id.required
                },
                name: {
                    required: objValMsgConst.name.required,
                    maxlength: objValMsgConst.name.max,
                    nameRegExp: objValMsgConst.name.regex
                }
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }

    $.validator.addMethod(
        "nameRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.name.regex
    );
    
})(jQuery);
