/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });

    function initMCEexact(selector){
        
        tinymce.init({
            selector: '#'+selector,  // change this value according to your HTML
            height: 270,
            auto_focus: 'editor',
            plugins : 'fullscreen autolink link image lists charmap print preview code',
            images_upload_url: '/image-upload',
            images_upload_base_path: 'uploads',
            images_upload_credentials: false,
            file_picker_types: 'file image media',            
            theme_advanced_buttons1 : "separator,insertdate,inserttime,preview,zoom,separator,forecolor,backcolor",
            theme_advanced_buttons2 : "bullist,numlist,separator,outdent,indent,separator,undo,redo,separator",
            theme_advanced_buttons3 : "hr,removeformat,visualaid,separator,sub,sup,separator,charmap",
            relative_urls : false,
            remove_script_host : false,
            images_upload_handler: function (blobInfo, success, failure) {
                var xhr, formData;

                xhr = new XMLHttpRequest();
                xhr.withCredentials = false;
                var token = $('meta[name="csrf-token"]').attr("content");
                xhr.open('POST', adminURL);
                xhr.setRequestHeader("X-CSRF-Token", token);

                xhr.onload = function() {
                  var json;

                  if (xhr.status != 200) {
                    failure('HTTP Error: ' + xhr.status);
                    return;
                  }

                  json = JSON.parse(xhr.responseText);

                  if (!json || typeof json.location != 'string') {
                    failure('Invalid JSON: ' + xhr.responseText);
                    return;
                  }

                  success(json.location);
                };
              //  console.log(json.location);
              //  document_base_url : url;
                formData = new FormData();
                formData.append('file', blobInfo.blob(), blobInfo.filename());

                xhr.send(formData);
            }
        });
    }

    if (typeof formId !== "undefined" && formId == "staticPagesForm") {

        initMCEexact("content");
        
        $("#staticPagesForm").validate({
            ignore: [],
            rules: {
                content: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                meta_title: {
                    required: true,
                    minlength: objValConst.meta_title.minLength,
                    maxlength: objValConst.meta_title.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                meta_description: {
                    required: true,
                    minlength: objValConst.meta_description.minLength,
                    maxlength: objValConst.meta_description.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                }
            },
            messages: {
                content: {
                    required: objValMsgConst.content.required,
                    minlength: objValMsgConst.content.min,
                    maxlength: objValMsgConst.content.max
                },
                meta_title: {
                    required: objValMsgConst.meta_title.required,
                    minlength: objValMsgConst.meta_title.min,
                    maxlength: objValMsgConst.meta_title.max
                },
                meta_description: {
                    required: objValMsgConst.meta_description.required,
                    minlength: objValMsgConst.meta_description.min,
                    maxlength: objValMsgConst.meta_description.max
                }
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }
})(jQuery);
