/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (typeof formId !== "undefined" && formId == "smtpForm") {
        $("#smtpForm").validate({
            ignore: [],
            rules: {
                driver: {
                    required: true,
                    minlength: objValConst.driver.minLength,
                    maxlength: objValConst.driver.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                host: {
                    required: true,
                    minlength: objValConst.host.minLength,
                    maxlength: objValConst.host.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                port: {
                    required: true,
                    minlength: objValConst.port.minLength,
                    maxlength: objValConst.port.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                username: {
                    required: true,
                    minlength: objValConst.username.minLength,
                    maxlength: objValConst.username.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                password: {
                    required: true,
                    minlength: objValConst.password.minLength,
                    maxlength: objValConst.password.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                encryption: {
                    required: false,
                    minlength: objValConst.encryption.minLength,
                    maxlength: objValConst.encryption.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                }
            },
            messages: {
                driver: {
                    required: objValMsgConst.driver.required,
                    minlength: objValMsgConst.driver.min,
                    maxlength: objValMsgConst.driver.max,
                },
                host: {
                    required: objValMsgConst.host.required,
                    minlength: objValMsgConst.host.min,
                    maxlength: objValMsgConst.host.max,
                },
                port: {
                    required: objValMsgConst.port.required,
                    minlength: objValMsgConst.port.min,
                    maxlength: objValMsgConst.port.max,
                },
                username: {
                    required: objValMsgConst.username.required,
                    minlength: objValMsgConst.username.min,
                    maxlength: objValMsgConst.username.max,
                },
                password: {
                    required: objValMsgConst.password.required,
                    minlength: objValMsgConst.password.min,
                    maxlength: objValMsgConst.password.max,
                },
                encryption: {
                    required: objValMsgConst.encryption.required,
                    minlength: objValMsgConst.encryption.min,
                    maxlength: objValMsgConst.encryption.max,
                }
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }
})(jQuery);
