/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility-users.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (typeof formId !== "undefined" && formId == "roleForm") {
        //alert("loginForm");
        $("#roleForm").validate({
            ignore: [],
            rules: {
                name: {
                    required: true,
                    maxlength: objValConst.name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //nameRegExp: objValConst.name.regex
                },
                description: {
                    required: true,
                    maxlength: objValConst.description.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                }
            },
            messages: {
                name: {
                    required: objValMsgConst.name.required,
                    maxlength: objValMsgConst.name.max,
                    nameRegExp: objValMsgConst.name.regex
                },
                description: {
                    required: objValMsgConst.description.required,
                    maxlength: objValMsgConst.description.max
                }
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }else if (window.location.href.indexOf("permissions") != -1) {
        var tw = new TreeView($, jsonObj, {
            showAlwaysCheckBox: true,
            fold: false
        });
        $("#tree-view").html(tw.root);
        $(".permissions").on("click", "#save-permissions", function() {
            var modules = [];
            $("div.alert").remove();
            $("#tree-view")
                .find("span.item")
                .each(function() {
                    if (parseInt($(this).attr("check-value"))) {
                        modules.push($(this).data("id"));
                    }
                });
            var roleId = $("#tree-view").data("roleid");

            if (modules.length) {
                $.post(
                    adminUrl + "/update-permission", // url
                    {
                        _token: $('meta[name="csrf-token"]').attr("content"),
                        modules: modules,
                        role_id: roleId
                    }, // data to be submit
                    function(data, status) {
                        // success callback
                        $(
                            '<div class="alert alert-' +
                                (data.success ? "success" : "danger") +
                                ' alert-block text-center"> ' +
                                '<button type="button" class="close" data-dismiss="alert">×</button>' +
                                "<strong>" +
                                data.message +
                                "</strong></div>"
                        ).insertBefore($(".content-header"));
                    }
                );
            } else {
                $.preloader.stop();
            }
        });
    }
    
    $.validator.addMethod(
        "nameRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.name.regex
    );
})(jQuery);
