/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility-users.blade.php
 * @dated: 20/Nov/2019
 */
 +(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (formId == "createRestaurant") {  
        //alert('svwf');
        $("#createRestaurant").validate({ 
            ignore: [],
            rules: {
                restaurant_bio: {
                    required: true,
                    minlength: objValConst.restaurant_bio.minLength,
                    maxlength: objValConst.restaurant_bio.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    restaurant_bioRegExp: objValConst.restaurant_bio.regex
                },
                restaurant_name: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                restaurant_phone_number: {
                    required: true,
                    minlength: objValConst.restaurant_phone_number.minLength,
                    maxlength: objValConst.restaurant_phone_number.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //restaurant_phone_numberRegExp: objValConst.restaurant_phone_number.regex
                },
                restaurant_email_id: {
                    required: true,
                    minlength: objValConst.restaurant_email_id.minLength,
                    maxlength: objValConst.restaurant_email_id.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    restaurant_email_idRegExp: objValConst.restaurant_email_id.regex
                },
                address1: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                address2: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                country: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                locality: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                deliverytime: {
                    required: true,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    restaurant_deliverytimeRegExp: objValConst.deliverytime.regex
                }, 
            },
            messages: {
                
                restaurant_name: {
                    required: objValMsgConst.restaurant_name.required,
                },

                restaurant_bio: {
                    required: objValMsgConst.restaurant_bio.required,
                    minlength: objValMsgConst.restaurant_bio.min,
                    maxlength: objValMsgConst.restaurant_bio.max,
                    restaurant_bioRegExp: objValMsgConst.restaurant_bio.regex
                },

                restaurant_phone_number: {
                    required: objValMsgConst.restaurant_phone_number.required,
                    minlength: objValMsgConst.restaurant_phone_number.min,
                    maxlength: objValMsgConst.restaurant_phone_number.max,
                },

                restaurant_email_id: {
                    required: objValMsgConst.restaurant_email_id.required,
                    minlength: objValMsgConst.restaurant_email_id.min,
                    maxlength: objValMsgConst.restaurant_email_id.max,
                    restaurant_email_idRegExp: objValMsgConst.restaurant_email_id.regex
                }, 
                address1: {
                    required: objValMsgConst.restaurant_address.required,
                },
                address2: {
                    required: objValMsgConst.restaurant_address2.required,
                },
                country: {
                    required: objValMsgConst.region.required,
                },
                locality: {
                    required: objValMsgConst.city.required,
                },
                deliverytime: {
                    required: objValMsgConst.deliverytime.required,
                    restaurant_deliverytimeRegExp: objValMsgConst.deliverytime.regex,
                    
                },
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }


   
    $.validator.addMethod(
        "restaurant_nameRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.restaurant_name.regex
    );

    $.validator.addMethod(
        "restaurant_bioRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.restaurant_bio.regex
    );

    $.validator.addMethod(
        "restaurant_phone_numberRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.restaurant_phone_number.regex
    );

    $.validator.addMethod(
        "restaurant_email_idRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.restaurant_email_id.regex
    );

    $.validator.addMethod(
        "restaurant_deliverytimeRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.deliverytime.regex
    );

    

  

    

   
})(jQuery);
