/**
 * @auther: NMG - PR
 * @Description: Javascript validations for mailbox:instatnt mailing module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/mailbox.blade.php
 * @dated: 13/Jan/2020
 */
$(document).ready(function() {
    +(function($) {
        "use strict";
        function initMCEexact(selector) {
            tinymce.init({
                selector: "#" + selector, // change this value according to your HTML
                branding: false,
                height: 270,
                auto_focus: "editor",
                plugins:
                    "fullscreen autolink link image lists charmap print preview code",
                images_upload_url: "/mailbox-image-upload",
                images_upload_base_path: "uploads",
                images_upload_credentials: false,
                file_picker_types: "file image media",
                theme_advanced_buttons1:
                    "separator,insertdate,inserttime,preview,zoom,separator,forecolor,backcolor",
                theme_advanced_buttons2:
                    "bullist,numlist,separator,outdent,indent,separator,undo,redo,separator",
                theme_advanced_buttons3:
                    "hr,removeformat,visualaid,separator,sub,sup,separator,charmap",
                relative_urls : false,
                remove_script_host : false,
                setup: function(editor) {
                    editor.on("focusout", function(e) {
                        //revalidate a field
                    });
                },
                images_upload_handler: function(blobInfo, success, failure) {
                    var xhr, formData;

                    xhr = new XMLHttpRequest();
                    xhr.withCredentials = false;
                    var token = $('meta[name="csrf-token"]').attr("content");
                    xhr.open("POST", adminURL);
                    xhr.setRequestHeader("X-CSRF-Token", token);

                    xhr.onload = function() {
                        var json;
                        if (xhr.status != 200) {
                            failure("HTTP Error: " + xhr.status);
                            return;
                        }
                        json = JSON.parse(xhr.responseText);
                        if (!json || typeof json.location != "string") {
                            failure("Invalid JSON: " + xhr.responseText);
                            return;
                        }
                        success(json.location);
                    };

                    formData = new FormData();
                    formData.append(
                        "file",
                        blobInfo.blob(),
                        blobInfo.filename()
                    );

                    xhr.send(formData);
                }
            });
        }
        //get checked radio button value
        var radioValue = $("input[name='type']:checked").val();
        //Flat red color scheme for iCheck
        $(
            'input[type="checkbox"].flat-red, input[type="radio"].flat-red'
        ).iCheck({
            checkboxClass: "icheckbox_flat-green",
            radioClass: "iradio_flat-green"
        });
        //radio button events
        $("#single").iCheck("check");
        $("input[type=radio][name=type]").on("ifChanged", function(event) {
            var inputValue = $(this).attr("value");
            radioValue = inputValue;
            var targetBox = $("." + inputValue);
            $(".volatile")
                .not(targetBox)
                .hide();
            $(targetBox).show();
            var validator = $("#mailboxForm").validate();
            validator.resetForm();
        });
        //Initialize Select2 Elements
        if ($(".select2")[0]) {
            //load select2 functioanlity
            $(".select2").select2();
            $("#role_id").on("change", function() {
                //revalidate a field
                $("#role_id").valid();
            });
        }
        if (typeof formId !== "undefined" && formId == "mailboxForm") {
            initMCEexact("content");
            //for triggering instant/broadcast email
            var validator = $("#mailboxForm").validate({
                ignore: [],
                rules: {
                    email: {
                        required: function(element) {
                            //alert(radioValue);
                            if (radioValue == "single") {
                                return $("#subjet").val() != "";
                            }
                            return false;
                        },
                        toRegExp: objValConst.email.regex,
                        normalizer: function(value) {
                            return $.trim(value);
                        }
                    },
                    "role_id[]": {
                        required: function(element) {
                            if (radioValue == "bulk") {
                                return $("#subjet").val() != "";
                            }
                            return false;
                        },
                        normalizer: function(value) {
                            return $.trim(value);
                        }
                    },
                    subject: {
                        required: function(element) {
                            if (radioValue == "single") {
                                return $("#email").val() != "";
                            } else if (radioValue == "bulk") {
                                return $("#role_id").val() != "";
                            }
                            return false;
                        },
                        maxlength: objValConst.subject.maxLength,
                        normalizer: function(value) {
                            return $.trim(value);
                        }
                    },
                    content: {
                        required: function(element) {
                            if (radioValue == "single") {
                                return $("#email").val() != "";
                            } else if (radioValue == "bulk") {
                                return $("#role_id").val() != "";
                            }
                            return false;
                        },
                        normalizer: function(value) {
                            return $.trim(value);
                        }
                    },
                    push_title: {
                        required: function(element) {
                            return $("#push_content").val() != "";
                        },
                        maxlength: objValConst.push_title.maxLength,
                        normalizer: function(value) {
                            return $.trim(value);
                        }
                    },
                    push_content: {
                        required: function(element) {
                            return $("#push_title").val() != "";
                            return false;
                        },
                        maxlength: objValConst.push_content.maxLength,
                        normalizer: function(value) {
                            return $.trim(value);
                        }
                    }
                },
                messages: {
                    email: {
                        required: objValMsgConst.email.required,
                        toRegExp: objValMsgConst.email.regex
                    },
                    "role_id[]": {
                        required: objValMsgConst.role_id.required
                    },
                    subject: {
                        required: objValMsgConst.subject.required,
                        maxlength: objValMsgConst.subject.max
                    },
                    content: {
                        required: objValMsgConst.content.required
                    },
                    push_title: {
                        required: objValMsgConst.push_title.required,
                        maxlength: objValMsgConst.push_title.max
                    },
                    push_content: {
                        required: objValMsgConst.push_title.required,
                        maxlength: objValMsgConst.push_title.max
                    }
                },

                errorElement: "span",
                errorClass: "help-block",
                errorPlacement: function(error, element) {
                    if (element.is(":radio"))
                        error.appendTo(
                            element
                                .parent()
                                .next()
                                .next()
                        );
                    else if (element.is(":checkbox"))
                        error.appendTo(element.parent().parent());
                    else error.appendTo(element.parent());
                },
                highlight: function(element, errorClass, validClass) {
                    $(element)
                        .parent()
                        .addClass("has-error");
                },
                unhighlight: function(element, errorClass, validClass) {
                    $(element)
                        .parent()
                        .removeClass("has-error");
                },
                submitHandler: function(form) {
                    var ajaxUrl = $("#postUrl").val(),
                        msg = $("#confirmMsg").val();
                    $.confirm({
                        text: msg,
                        confirm: function() {
                            /* let data = $("form").serialize();
                            loadAjax(ajaxUrl, formData); */
                            $("#results").innerHTML = "";
                            $("#modal").show();
                            $("#fade").show();
                            // Get form
                            var form = $("#mailboxForm")[0];
                            // Create an FormData object
                            var formData = new FormData(form);
                            // If you want to add an extra field for the FormData
                            /* formData.append(
                                "attachment",
                                "This is some extra data, testing"
                            ); */
                            $.ajax({
                                type: "POST",
                                url: ajaxUrl,
                                data: formData,
                                enctype: "multipart/form-data",
                                processData: false, // Important!
                                contentType: false,
                                cache: false,
                                success: function(resObj) {
                                    var html = '<div class="col-md-9">';
                                    if (resObj.status == "error") {
                                        html +=
                                            '<div class="alert alert-danger alert-dismissible"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button><h4><i class="icon fa fa-ban"></i> Error!</h4>' +
                                            resObj.message +
                                            "</div>";
                                    } else if (resObj.status == "success") {
                                        html +=
                                            '<div class="alert alert-success alert-dismissible"><h4><i class="icon fa fa-check"></i><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button> Success!</h4>' +
                                            resObj.message +
                                            "</div>";
                                    } else {
                                        html +=
                                            '<div class="alert alert-danger alert-dismissible"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button><h4><i class="icon fa fa-ban"></i> Error!</h4>Something went wrong.</div>';
                                    }
                                    html +=
                                        '<p><a href="' +
                                        window.location.href +
                                        '">Go back</a></p></div>';

                                    $("#modal").hide();
                                    $("#fade").hide();
                                    $("#results").html(html);
                                },
                                error: function(err) {
                                    var html = '<div class="col-md-9">';
                                    html +=
                                        '<div class="alert alert-success alert-dismissible"><h4><i class="icon fa fa-check"></i><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button> Success!</h4>' +
                                        err +
                                        "</div>";
                                    html +=
                                        '<p><a href="' +
                                        window.location.href +
                                        '">Go back</a></p></div>';
                                    $("#modal").hide();
                                    $("#fade").hide();
                                    $("#results").html(html);
                                }
                            });
                        },
                        cancel: function() {
                            return false;
                        }
                    });
                }
            });
        }
        $.validator.addMethod(
            "toRegExp",
            function(value, element, regexp) {
                var re = new RegExp(regexp);
                return this.optional(element) || re.test(value);
            },
            objValMsgConst.email.regex
        );
    })(jQuery);
});
function openModal() {
    document.getElementById("modal").style.display = "block";
    document.getElementById("fade").style.display = "block";
}

function closeModal() {
    document.getElementById("modal").style.display = "none";
    document.getElementById("fade").style.display = "none";
}

function loadAjax(url, data) {
    document.getElementById("results").innerHTML = "";
    openModal();
    var xhr = false;
    if (window.XMLHttpRequest) {
        xhr = new XMLHttpRequest();
    } else {
        xhr = new ActiveXObject("Microsoft.XMLHTTP");
    }
    if (xhr) {
        xhr.onreadystatechange = function() {
            if (xhr.readyState == 4 && xhr.status == 200) {
                let jsonResponse = JSON.parse(xhr.responseText);
                let html = '<div class="col-md-9">';

                if (jsonResponse.status == "error") {
                    html +=
                        '<div class="alert alert-danger alert-dismissible"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button><h4><i class="icon fa fa-ban"></i> Error!</h4>' +
                        jsonResponse.message +
                        "</div>";
                } else if (jsonResponse.status == "success") {
                    html +=
                        '<div class="alert alert-success alert-dismissible"><h4><i class="icon fa fa-check"></i><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button> Success!</h4>' +
                        jsonResponse.message +
                        "</div>";
                } else {
                    html +=
                        '<div class="alert alert-danger alert-dismissible"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button><h4><i class="icon fa fa-ban"></i> Error!</h4>Something went wrong.</div>';
                }
                html +=
                    '<p><a href="' +
                    window.location.href +
                    '">Go back</a></p></div>';
                closeModal();
                document.getElementById("results").innerHTML = html;
            }
        };
        /* xhr.open("GET", url, true);
        xhr.send(null); */

        xhr.open("POST", url, true);
        //Send the proper header information along with the request
        xhr.setRequestHeader(
            "Content-type",
            "application/x-www-form-urlencoded"
        );

        xhr.send(data);
    }
}

$('#attachment').on('change',function(){
    //get the file name
    var name = document.getElementById('attachment'); 
    var fileName = name.files.item(0).name;
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html(fileName);
})
