/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility-users.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
     if (formId == "createTax") {
        //alert('svwf');
        $("#createTax").validate({
            ignore: [],
            rules: {
                tax: {
                    required: true,
                    minlength: objValConst.tax.minLength,
                    maxlength: objValConst.tax.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    taxRegExp:objValConst.tax.regex,
                }
            },
            messages: {

                tax: {
                    required: objValMsgConst.tax.required,
                    minlength: objValMsgConst.tax.min,
                    maxlength: objValMsgConst.tax.max,
                    taxRegExp: objValMsgConst.tax.regex
                },
            },

            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }

    else if (formId == "createDeliveryCharge") {
        //alert('svwf');
        $("#createDeliveryCharge").validate({
            ignore: [],
            rules: {
                delivery_charge: {
                    required: true,
                    minlength: objValConst.delivery_charge.minLength,
                    maxlength: objValConst.delivery_charge.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    taxRegExp:objValConst.delivery_charge.regex,
                }
            },
            messages: {

                delivery_charge: {
                    required: objValMsgConst.delivery_charge.required,
                    minlength: objValMsgConst.delivery_charge.min,
                    maxlength: objValMsgConst.delivery_charge.max,
                    taxRegExp: objValMsgConst.delivery_charge.regex
                },
            },

            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }


    $.validator.addMethod(
        "taxRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.tax.regex
    );

    $.validator.addMethod(
        "delivery_chargeRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.delivery_charge.regex
    );


})(jQuery);
