/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility-users.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (formId == "createCommissionCharge") {
        //alert('svwf');
        $("#createCommissionCharge").validate({
            ignore: [],
            rules: {
                admin_commison: {
                    required: true,
                    minlength: objValConst.admin_commison.minLength,
                    maxlength: objValConst.admin_commison.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    admin_commisonRegExp:objValConst.admin_commison.regex,
                }
            },
            messages: {

                admin_commison: {
                    required: objValMsgConst.admin_commison.required,
                    minlength: objValMsgConst.admin_commison.min,
                    maxlength: objValMsgConst.admin_commison.max,
                    admin_commisonRegExp: objValMsgConst.admin_commison.regex
                },
            },

            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }



    $.validator.addMethod(
        "admin_commisonRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.admin_commison.regex
    );


})(jQuery);
