/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility-users.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (formId == "createCategory") {
        //alert('svwf');
        $("#createCategory").validate({
            ignore: [],
            rules: {
                category: {
                    required: true,
                    minlength: objValConst.category.minLength,
                    maxlength: objValConst.category.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    categoryRegExp:objValConst.category.regex,
                }
            },
            messages: {

                category: {
                    required: objValMsgConst.category.required,
                    minlength: objValMsgConst.category.min,
                    maxlength: objValMsgConst.category.max,
                    nameRegExp: objValMsgConst.category.regex
                },
            },

            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }



    $.validator.addMethod(
        "categoryRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.category.regex
    );


})(jQuery);
