/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (typeof formId !== "undefined" && formId == "facilityForm") {
        $("#facilityForm").validate({
            ignore: [],
            rules: {
                name: {
                    required: true,
                    maxlength: objValConst.name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //nameRegExp: objValConst.name.regex
                },
                address: {
                    required: true,
                    maxlength: objValConst.address.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                phone_number: {
                    required: false,
                    maxlength: objValConst.phone_number.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    phoneRegExp: objValConst.phone_number.regex
                },
                admin_id: {
                    required: false,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                color_code: {
                    required: false,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    colorCodeRegExp: objValConst.color_code.regex
                },
                logo: {
                    accept: objValConst.logo.mimes,
                    extension: objValConst.logo.mimes
                }
            },
            messages: {
                name: {
                    required: objValMsgConst.name.required,
                    maxlength: objValMsgConst.name.max,
                    nameRegExp: objValMsgConst.name.regex
                },
                address: {
                    required: objValMsgConst.address.required,
                    maxlength: objValMsgConst.address.max
                },
                phone_number: {
                    required: objValMsgConst.address.required,
                    phoneRegExp: objValMsgConst.phone_number.regex
                },
                admin_id: {
                    required: objValMsgConst.address.required
                },
                color_code: {
                    colorCodeRegExp: objValMsgConst.color_code.regex
                },
                logo: {
                    filesize: objValMsgConst.logo.filesize,
                    extension: objValMsgConst.logo.mimes,
                    accept: objValMsgConst.logo.mimes
                }
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }

    $.validator.addMethod(
        "nameRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.name.regex
    );

    $.validator.addMethod(
        "colorCodeRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.color_code.regex
    );

    $.validator.addMethod(
        "phoneRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.phone_number.regex
    );
    
})(jQuery);
