/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });

    function initMCEexact(selector){
        
        tinymce.init({
            selector: '#'+selector,  // change this value according to your HTML
            height: 270,
            auto_focus: 'editor',
            plugins : 'fullscreen autolink link image lists charmap print preview code',
            images_upload_url: '/image-upload',
            images_upload_base_path: 'uploads',
            images_upload_credentials: false,
            file_picker_types: 'file image media',            
            theme_advanced_buttons1 : "separator,insertdate,inserttime,preview,zoom,separator,forecolor,backcolor",
            theme_advanced_buttons2 : "bullist,numlist,separator,outdent,indent,separator,undo,redo,separator",
            theme_advanced_buttons3 : "hr,removeformat,visualaid,separator,sub,sup,separator,charmap",
            images_upload_handler: function (blobInfo, success, failure) {
                var xhr, formData;

                xhr = new XMLHttpRequest();
                xhr.withCredentials = false;
                var token = $('meta[name="csrf-token"]').attr("content");
                xhr.open('POST', adminURL);
                xhr.setRequestHeader("X-CSRF-Token", token);

                xhr.onload = function() {
                  var json;

                  if (xhr.status != 200) {
                    failure('HTTP Error: ' + xhr.status);
                    return;
                  }

                  json = JSON.parse(xhr.responseText);

                  if (!json || typeof json.location != 'string') {
                    failure('Invalid JSON: ' + xhr.responseText);
                    return;
                  }

                  success(json.location);
                };

                formData = new FormData();
                formData.append('file', blobInfo.blob(), blobInfo.filename());

                xhr.send(formData);
            }
        });
    }

    if (typeof formId !== "undefined" && formId == "emailTemplateForm") {

        initMCEexact("content");
        
        $("#emailTemplateForm").validate({
            ignore: [],
            rules: {
                subject: {
                    required: true,
                    minlength: objValConst.subject.minLength,
                    maxlength: objValConst.subject.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    }
                },
                content: {
                    minlength: objValConst.content.minLength,
                    //maxlength: objValConst.content.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
            },
            messages: {
                subject: {
                    required: objValMsgConst.subject.required,
                    minlength: objValMsgConst.subject.min,
                    maxlength: objValMsgConst.subject.max
                },
                content: {
                    required: objValMsgConst.content.required,
                    minlength: objValMsgConst.content.min,
                    maxlength: objValMsgConst.content.max
                },
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }
})(jQuery);
