/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility-users.blade.php
 * @dated: 20/Nov/2019
 */
 +(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (formId == "editDeliveryPerson") {
        //alert('svwf');
        $("#editDeliveryPerson").validate({
            ignore: [],
            rules: {
                role_id: {
                    required: true
                },
                facility_id: {
                    //required: true
                },
                department_id: {
                    required: true
                },
                title_id: {
                    required: true
                },
                user_name: {
                    required: true,
                    minlength: objValConst.user_name.minLength,
                    maxlength: objValConst.user_name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    userNameRegExp: objValConst.user_name.regex
                },
                email: {
                    required: true,
                    minlength: objValConst.email.minLength,
                    maxlength: objValConst.email.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                phone_number: {
                    minlength: objValConst.phone_number.minLength,
                    maxlength: objValConst.phone_number.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    phoneRegExp:objValConst.phone_number.regex,
                },
                mobile_no: {
                    required: true,
                    minlength: objValConst.mobile_no.minLength,
                    maxlength: objValConst.mobile_no.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    mobileRegExp:objValConst.mobile_no.regex,
                },
                
                first_name: {
                    required: true,
                    minlength: objValConst.first_name.minLength,
                    maxlength: objValConst.first_name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //fNameRegEx: objValConst.first_name.regex
                },
                last_name: {
                    required: true,
                    minlength: objValConst.last_name.minLength,
                    maxlength: objValConst.last_name.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                    //lNameRegEx: objValConst.last_name.regex
                },
                avatar: {
                    accept: "jpeg,jpg,png",
                    extension: "jpeg,jpg,png,gif"
                },
                age: {
                    required: true,
                    minlength: objValConst.age.minLength,
                    maxlength: objValConst.age.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                },

                
                account_details: {
                    required: true,
                    minlength: objValConst.account_details.minLength,
                    normalizer: function(value) {
                    return $.trim(value);
                        },
                },
                
                role_id: {
                    required: true
                }
            },
            messages: {
                role_id: {
                    required: objValMsgConst.role_id.required
                },
                facility_id: {
                    required: objValMsgConst.facility_id.required
                },
                department_id: {
                    required: objValMsgConst.department_id.required
                },
                title_id: {
                    required: objValMsgConst.title_id.required
                },
                user_name: {
                    required: objValMsgConst.user_name.required,
                    minlength: objValMsgConst.user_name.min,
                    maxlength: objValMsgConst.user_name.max,
                    userNameRegExp: objValMsgConst.user_name.regex
                },
                email: {
                    required: objValMsgConst.email.required,
                    minlength: objValMsgConst.email.min,
                    maxlength: objValMsgConst.email.max,
                    email: objValMsgConst.email.email,
                    emailRegExp: objValMsgConst.email.regex
                },
                phone_number: {
                    minlength: objValMsgConst.phone_number.min,
                    maxlength: objValMsgConst.phone_number.max,
                    phoneRegExp: objValMsgConst.phone_number.regex

                },
                mobile_no: {
                    required: objValMsgConst.mobile_no.required,
                    minlength: objValMsgConst.mobile_no.min,
                    maxlength: objValMsgConst.mobile_no.max,
                    mobileRegExp: objValMsgConst.mobile_no.regex

                },

                
                first_name: {
                    required: objValMsgConst.first_name.required,
                    minlength: objValMsgConst.first_name.min,
                    maxlength: objValMsgConst.first_name.max,
                    fNameRegEx: objValMsgConst.first_name.regex
                },
                last_name: {
                    required: objValMsgConst.last_name.required,
                    minlength: objValMsgConst.last_name.min,
                    maxlength: objValMsgConst.last_name.max,
                    lNameRegEx: objValMsgConst.last_name.regex
                },
                avatar: {
                    filesize: objValMsgConst.avatar.filesize,
                    extension: objValMsgConst.avatar.mimes,
                    accept: objValMsgConst.avatar.mimes
                },
                age: {
                    required: objValMsgConst.age.required,
                    minlength: objValMsgConst.age.min,
                    maxlength: objValMsgConst.age.max,
                    ageRegEx: objValMsgConst.age.regex
                },

                
                account_details: {
                    required: objValMsgConst.account_details.required,
                    minlength: objValMsgConst.account_details.min,
                    id_proofRegEx: objValMsgConst.account_details.regex
                },

                

                
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }
    $.validator.addMethod(
        "userNameRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.user_name.regex
    );

    $.validator.addMethod(
        "mobileRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.mobile_no.regex
    );

    $.validator.addMethod(
        "phoneRegExp",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.phone_number.regex
    );

    $.validator.addMethod(
        "lNameRegEx",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.last_name.regex
    );

    $.validator.addMethod(
        "ageRegEx",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.age.regex
    );

    $.validator.addMethod(
        "id_proofRegEx",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.id_proof.regex
    );

    $.validator.addMethod(
        "account_detailsRegEx",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.account_details.regex
    );

    $.validator.addMethod(
        "vehicle_infoRegEx",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.vehicle_info.regex
    );

    $.validator.addMethod(
        "driving_licenseRegEx",
        function(value, element, regexp) {
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        objValMsgConst.driving_license.regex
    );

    $.validator.addMethod("customemail",
            function (value, element) {
                return this.optional(element) || /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/.test(value);
            },
            "Please enter valid email address"
    );
})(jQuery);
