/**
 * @auther: NMG - PR
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/facility.blade.php
 * @dated: 20/Nov/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (typeof formId !== "undefined" && formId == "blockedReasonForm") {
        $("#blockedReasonForm").validate({
            ignore: [],
            rules: {
                reason: {
                    required: true,
                    minlength: objValConst.reason.minLength,
                    maxlength: objValConst.reason.maxLength,
                    normalizer: function(value) {
                        return $.trim(value);
                    },
                }
            },
            messages: {
                reason: {
                    required: objValMsgConst.reason.required,
                    minlength: objValMsgConst.reason.min,
                    maxlength: objValMsgConst.reason.max,
                }
            },
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }
})(jQuery);
