/**
 * @auther: Bibhash
 * @Description: Javascript validations for user module. Constants like objValMsgConst & objValMsgConst are taken from-
 *  /resources/view/elements/Admin/lang/validation/app-version.blade.php
 * @dated: 26/Aug/2019
 */
+(function($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = false,
        deleteConfirm = false;
    $("input").iCheck({
        checkboxClass: "icheckbox_square-blue",
        radioClass: "iradio_square-blue",
        increaseArea: "20%" /* optional */
    });
    if (typeof formId !== "undefined" && formId == "appVersionForm") {
        
        $("#appVersionForm").validate({
            ignore: [],
            rules: {
                android_version: {
                    required: true,
                    androidValidator: true,
                    normalizer: function(value) {
                    return $.trim(value);
                },
                },
                ios_version: {
                     required: true,
                     iosValidator: true,
                     normalizer: function(value) {
                        return $.trim(value);
                    },
                },
                android_update_message: {
                    required: true,
                    minlength: objValConst.android_update_message.minLength,
                    maxlength: objValConst.android_update_message.maxLength,
                    normalizer: function(value) {
                       return $.trim(value);
                   },
               },
               ios_update_message: {
                    required: true,
                    minlength: objValConst.ios_update_message.minLength,
                    maxlength: objValConst.ios_update_message.maxLength,
                    normalizer: function(value) {
                    return $.trim(value);
                   },
                },
                force_update_ios:{
                        required: true,
                        normalizer: function(value) {
                            return $.trim(value);
                        },
                    },
                force_update_android:{
                        required: true,
                        normalizer: function(value) {
                            return $.trim(value);
                        },
                }
            },
            messages: {
                android_version: {
                    required: objValMsgConst.android_version.required,
                   // minlength: objValMsgConst.android_version.min,
                   // maxlength: objValMsgConst.android_version.max,
                    regex: objValMsgConst.android_version.regex,
                },
                ios_version: {
                    required: objValMsgConst.ios_version.required,
                    minlength: objValMsgConst.ios_version.min,
                    maxlength: objValMsgConst.ios_version.max,
                  //  androidversionreg: objValMsgConst.ios_version.regex,
                },
                android_update_message: {
                    required: objValMsgConst.android_update_message.required,
                    minlength: objValMsgConst.android_update_message.min,
                    maxlength: objValMsgConst.android_update_message.max,
                },
                ios_update_message: {
                    required: objValMsgConst.ios_update_message.required,
                    minlength: objValMsgConst.ios_update_message.min,
                    maxlength: objValMsgConst.ios_update_message.max,
                },
                force_update_ios: {
                    required: objValMsgConst.force_update_ios.required,
                },
                force_update_android: {
                    required: objValMsgConst.force_update_android.required,
                },
            },

            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(error, element) {
                if (element.is(":radio"))
                    error.appendTo(
                        element
                            .parent()
                            .next()
                            .next()
                    );
                else if (element.is(":checkbox"))
                    error.appendTo(element.parent().parent());
                else error.appendTo(element.parent());
            },
            highlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element)
                    .parent()
                    .removeClass("has-error");
            }
        });
    }

    // Android validation for special condition.
    $.validator.addMethod("androidValidator", function(value, element) {
        return this.optional(element) || /((\d+)((\.\d{1,2})?))$/ .test(value);
     },
      'Android version starts with a digit, can have any number of digit, only digits and (.) are allowed.'
    );

    // Ios validation for special condition.
    $.validator.addMethod("iosValidator", function(value, element) {
        return this.optional(element) || /((\d+)((\.\d{1,2})?))$/ .test(value);
     },
      'Ios version starts with a digit, can have any number of digit, only digits and (.) are allowed.'
    );
})(jQuery);
