$(document).ready(function () {
    $(".fancybox").fancybox();
    $(".ImgPopup").fancybox({
        helpers: {
            title: {
                type: "outside"
            },
            overlay: {
                speedOut: 0
            }
        }
    });
    if ($(".various").length > 0) {
        $(".various").fancybox({
            maxWidth: 768,
            /*maxHeight	: 600,*/
            fitToView: false,
            width: "70%",
            height: "70%",
            autoSize: true,
            closeClick: true,
            openEffect: "none",
            closeEffect: "none",
            scrolling: "auto",
            preload: true
        });
        $(".single_1").fancybox({
            helpers: {
                title: {
                    type: "float"
                }
            }
        });
    }
    //mailbox/send instant message module
    $(function () {
        //Initialize Select2 Elements
        if ($(".select2")[0]) {
            $(".select2").select2();
        }
    });
});
function trim(el) {
    el.value = el.value
        .replace(/(^\s*)|(\s*$)/gi, "") // removes leading and trailing spaces
        .replace(/[ ]{2,}/gi, " ") // replaces multiple spaces with one space
        .replace(/\n +/, "\n"); // Removes spaces after newlines
    return;
}
/**
 * Develper Js
 * ------------------
 * You should use this file in production.
 * This file is for admin developer console
 */
+(function ($) {
    "use strict";
    //for checkboxes
    var useStatusFlag = true,
        deleteConfirm = true;
    // $("input").iCheck({
    //     checkboxClass: "icheckbox_square-blue",
    //     radioClass: "iradio_square-blue",
    //     increaseArea: "20%" /* optional */
    // });

    $("body").on('change', 'select.facility_id', function () {

        var varID = $(this).val();
        var _token = $('meta[name="csrf-token"]').attr("content");

        $.ajax({
            url: adminFacilityURL,
            type: "get",
            data: {
                _token: _token,
                facility_id: varID
            },
            success: function (data) {
                $('.parent_id option').remove();
                if (data.success) {
                    $('.parent_id').html(data.html);

                } else {
                    $('.parent_id').append(new Option("--Choose One--", ''));
                    //$('.title').append(new Option("--Choose One--", ''));
                }

                if (data.titleSuccess) {
                    $('.title_id').html(data.titleHtml);
                    $('.title_id').html(data.titleHtml);

                } else {
                    $('.title_id option').remove();
                    $('.title_id').append(new Option("--Choose One--", ''));
                }
            },
            error: function (xhr, status, error) {
                alert("something went wrong");
            }
        });
    });

    if (useStatusFlag) {
        $(".change-status-confirm").on("click", function (e) {
            var id = $(this).attr("data"),
                table = $(this).attr("model"),
                msg = $(this).attr("msg"),
                baseUrl = $(this).attr("baseUrl"),
                _token = $('meta[name="csrf-token"]').attr("content");
            e.preventDefault();
            $.confirm({
                text: msg,
                confirm: function () {
                    var $this = $(this);
                    $.ajax({
                        url: baseUrl,
                        type: "get",
                        data: {
                            _token: _token,
                            model: table,
                            id: id
                        },
                        success: function (data) {
                            if (data.success) {
                                $("#" + data.id).html(data.changeStatus.status);
                                if (data.changeStatus.status == "Inactive") {
                                    $("#" + data.id)
                                        .removeClass("Active")
                                        .addClass("Inactive");
                                } else {
                                    $("#" + data.id)
                                        .removeClass("Inactive")
                                        .addClass("Active");
                                }
                            }
                            else {
                                alert(data.msg);
                            }
                        },
                        error: function (xhr, status, error) {
                            alert("Access denined");
                        }
                    });
                },
                cancel: function () {
                    return false;
                }
            });
        });
    }









    if (deleteConfirm) {
        $(".delete-confirm").on("click", function (e) {
            e.preventDefault();
            var $this = $(this),
                msg = $this.attr("msg");
            $.confirm({
                text: msg,
                confirm: function () {
                    $($this)
                        .closest("form")
                        .submit();
                },
                cancel: function () {
                    return false;
                }
            });
        });
    }

    /* remove restaurant type checkbox.*/
    $(".restaurantType").attr("style", "");

})(jQuery);
function goBack() {
    window.history.back();
}


$(document).on('submit', '#rejectDeliveryPersonForm', function (e) {
    e.preventDefault();
    var formdata = $("#rejectDeliveryPersonForm").serialize();
    var url = $(this).attr('action');
    $("#sbt-btn").html("saving...").attr('disabled', true);
    $.ajax({
        type: 'post',
        url: url,
        data: formdata,
        success: function (data) {
            $("#sbt-btn").html("Save").attr('disabled', false);
            if (data.success) {
                $("#approvalStatus" + data.id).html(data.changeStatus.status);
                $("#reject-delivery-person-modal").modal('hide');
            }
        },
        error: function (xhr, status, error) {
            $("#sbt-btn").html("Save").attr('disabled', false);
            alert("Access denined");
        }

    });
})


$(document).on('click', '.change-approve-status', function (e) {
    var id = $(this).attr('data');
    var baseUrl = $(this).attr('baseUrl');
    var msg = $(this).attr('msg');
    var status = $(this).attr('status');
    var _token = $('meta[name="csrf-token"]').attr("content");
    var actionBtn = $(this).closest('.change-approve-status').find('.buttonload');
    var actionBtnHtml = actionBtn.html();
    e.preventDefault();
    $.confirm({
        text: msg,
        confirm: function () {
            var $this = $(this);
            if (status == 'approve') {
                actionBtn.html('<i class="fa fa-refresh fa-spin"></i> ' + actionBtnHtml);
                $.ajax({
                    url: baseUrl,
                    type: "post",
                    data: {
                        _token: _token,
                        id: id,
                        status: status
                    },
                    success: function (data) {
                        if (data.success) {
                            $("#approvalStatus" + data.id).html(data.changeStatus.status);
                        }
                    },
                    error: function (xhr, status, error) {
                        alert("Access denined");
                    }
                });
            }
            else {
                // reject remark need to capture in modal
                $(".rejected_data_id").val(id);
                $("#reject-delivery-person-modal").modal('show');
            }

        },
        cancel: function () {
            return false;
        }
    });
});


jQuery(document).ready(function () {
    jQuery('#restaurantUpd').click(function () {
        var checked = jQuery("input[type=checkbox]:checked").length;
        var latitude = jQuery('input[name="latitude"]').val();
        var longitude = jQuery('input[name="longitude"]').val();

        if (!checked) {
            $('#restaurant_type-error').html('The restaurant type field is required.');
            return false;
        }

        if (!latitude) {
            $('#addressAdmin-error').html('The Address1 field is required for autosuggestion.');
            return false;
        }

        if (!longitude) {
            $('#addressAdmin-error').html('The Address1 field is required for autosuggestion.');
            return false;
        }

    });
});


$(document).on('click', '#selectAllCheckbox', function () {
    if ($(this).prop('checked') == true) {
        $(".orderCheckBox").prop('checked', true);
    }
    else {
        $(".orderCheckBox").prop('checked', false);
    }
});


function restaurantAmountPayHandler() {
   // console.log($(this).val()); return;
    var _token = $('meta[name="csrf-token"]').attr("content");
    var conf = confirm("Are you sure to mark paid?");
    if (conf == true) {
        var checkedOrders = [];
        $(".orderCheckBox:checkbox:checked").each(function () {
            checkedOrders.push($(this).val());
        });

        var checkedOrderLen = checkedOrders.length;
        if (checkedOrderLen == 0) {
            alert("Please select atleast one order to change status!");
            return false;
        }
        else {
            $.post(
                adminURL + "/restaurant-transaction/paymentStatusHandler",
                { orderIds: checkedOrders, _token: _token, status: 1 },
                function (resp) {
                    var res = jQuery.parseJSON(resp);
                    if (res.status == 1) {
                        alert(res.msg);
                        window.location.reload();
                    } else {
                        alert(res.msg);
                    }
                }
            );
        }

        console.log(checkedOrders);
    }


}



function riderAmountPayHandler() {
    var _token = $('meta[name="csrf-token"]').attr("content");
    var conf = confirm("Are you sure to mark paid?");
    if (conf == true) {
        var checkedOrders = [];
        $(".orderCheckBox:checkbox:checked").each(function () {
            checkedOrders.push($(this).val());
        });

        var checkedOrderLen = checkedOrders.length;
        if (checkedOrderLen == 0) {
            alert("Please select atleast one order to change status!");
            return false;
        }
        else {
            $.post(
                adminURL + "/rider-transaction/paymentStatusHandler",
                { orderIds: checkedOrders, _token: _token, status: 1 },
                function (resp) {
                    var res = jQuery.parseJSON(resp);
                    if (res.status == 1) {
                        alert(res.msg);
                        window.location.reload();
                    } else {
                        alert(res.msg);
                    }
                }
            );
        }
    }
}

