const elixir = require("laravel-elixir");

require("laravel-elixir-image-optimize");
require('dotenv').config();
//console.log(process.env.APP_ENV);

//elixir.config.production = true;
//elixir.config.sourcemaps = false;
elixir.config.cssOutput = "public/css";
elixir.config.jsOutput = "public/js";
elixir.config.assetsPath = `${__dirname}/resources/assets/`;
var applicationName = process.env.APP_ENV;


elixir(mix => {
  if (applicationName != 'local') {
    //////Dashboard Min Css Minified/////////
    mix.styles(
      [
        "../css/bootstrap.min.css",
        "../css/font-awesome.min.css",
        "../css/select2.min.css",
        "../css/ionicons.min.css",
        "../css/AdminLTE.min.css",
        "../css/blue.min.css",
        "../css/skin-blue.min.css",
        "../css/custom.css",
      ],
      `public/css/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.dashboard.min.css`
    );

    //////Admin Form Min Css Minified/////////
    mix.styles(
      [
        "../css/bootstrap.min.css",
        "../css/font-awesome.min.css",
        "../css/select2.min.css",
        "../css/ionicons.min.css",
        "../css/AdminLTE.min.css",
        "../css/blue.min.css",
        "../css/skin-blue.min.css",
        "../css/custom.css",
      ],
      `public/css/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminForm.min.css`
    );

    //////Login Form Min Css Minified/////////
    mix.styles(
      [
        "../css/bootstrap.min.css",
        "../css/AdminLTE.min.css",
        "../css/blue.min.css",
        "../css/custom.css",
      ],
      `public/css/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminLogin.min.css`
    );

    //////Admin Pdf Min Css Minified/////////
    mix.styles(
      [
        "../css/bootstrap.min.css",
        "../css/font-awesome.min.css",
        "../css/ionicons.min.css",
        "../css/AdminLTE.min.css",
        "../css/blue.min.css",
        "../css/custom.css",
      ],
      `public/css/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminPdf.min.css`
    );

    //////Admin Popup Min Css Minified/////////
    mix.styles(
      [
        "../css/bootstrap.min.css",
        "../css/font-awesome.min.css",
        "../css/ionicons.min.css",
        "../css/AdminLTE.min.css",
        "../css/blue.min.css",
        "../css/skin-blue.min.css",
        "../css/custom.css",
      ],
      `public/css/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminPopup.min.css`
    );

    //////Errors Min Css Minified/////////
    mix.styles(
      [
        "../css/bootstrap.min.css",
        "../css/AdminLTE.min.css",
        "../plugins/iCheck/square/blue.css",
        "../css/custom.css",
      ],
      `public/css/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.errors.min.css`
    );

    //////Mailbox Form Min Css Minified/////////
    mix.styles(
      [
        "../css/bootstrap.min.css",
        "../css/font-awesome.min.css",
        "../css/select2.min.css",
        "../css/skin-blue.min.css",
        "../css/AdminLTE.min.css",
        "../css/custom.css",
      ],
      `public/css/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.mailboxForm.min.css`
    );

    //////Dashboard Min Js Minified/////////
    mix.scripts([
      '../js/jquery.min.js',
      '../js/bootstrap.min.js',
      '../js/fastclick.min.js',
      '../js/adminlte.min.js',
      '../js/icheck.min.js',
      '../js/jquery.confirm.min.js',
      '../js/ckeditor.min.js',
      '../js/select2.full.min.js',
      '../js/custom.js',
    ],
      `public/js/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.dashboard.min.js`
    );

    //////Admin Form Js Minified/////////

    //****Part1****/
    mix.scripts([
      '../js/jquery.min.js',
      '../js/bootstrap.min.js',
      '../js/adminlte.min.js',
      '../plugins/jquery-validate/jquery.validate.js',
      '../plugins/jquery-validate/additional.methods.js',
      '../js/icheck.min.js',
      '../js/jquery.confirm.min.js',
    ],
      `public/js/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminForm.min.js`
    );

    //****Part2****/
    mix.scripts([
      '../js/jscolor.js',
      '../js/select2.full.min.js',
      '../js/custom.js',
    ],
      `public/js/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminForm1.min.js`
    );

    //////Admin Login Js Minified/////////
    //****Part1****/
    mix.scripts([
      '../js/jquery.min.js',
      '../js/bootstrap.min.js',
      '../js/fastclick.min.js',
      '../plugins/iCheck/icheck.min.js',
      '../plugins/jquery-validate/jquery.validate.js',
    ],
      `public/js/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminLogin.min.js`
    );

    //****Part2****/
    mix.scripts([
      '../js/validation/user.js',
    ],
      `public/js/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminLogin1.min.js`
    );

    //////Admin PDF Min Js Minified/////////
    mix.scripts([
      '../js/jquery.min.js',
      '../js/bootstrap.min.js',
      '../js/adminlte.min.js',
    ],
      `public/js/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminPdf.min.js`
    );

    //////Admin Popup Min Js Minified/////////
    mix.scripts([
      '../js/jquery.min.js',
      '../js/bootstrap.min.js',
      '../js/fastclick.min.js',
      '../js/adminlte.min.js',
      '../js/icheck.min.js',
      '../js/jquery.confirm.min.js',
      '../js/ckeditor.min.js',
      '../js/custom.js',
    ],
      `public/js/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.adminPopup.min.js`
    );

    //////Mailbox Form Js Minified/////////

    //****Part1****/
    mix.scripts([
      '../js/jquery.min.js',
      '../js/bootstrap.min.js',
      '../js/adminlte.min.js',
      '../plugins/jquery-validate/jquery.validate.js',
      '../plugins/jquery-validate/additional.methods.js',
      '../js/icheck.min.js',
      '../js/jquery.confirm.min.js',
    ],
      `public/js/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.mailboxForm.min.js`
    );

    //****Part2****/
    mix.scripts([
      '../js/jscolor.js',
      '../js/select2.full.min.js',
      '../js/custom.js',
    ],
      `public/js/${applicationName
        .toLowerCase()
        .replace(" ", "-")}.mailboxForm1.min.js`
    );
  }
});
