<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRiderEarningTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('rider_earning', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->unsignedBigInteger('rider_id')->comment('Customer ID');
			$table->unsignedBigInteger('order_id');
			$table->double('amount');
			$table->timestamps();

			$table->foreign('order_id')->references('id')->on('orders');
			$table->foreign('rider_id')->references('id')->on('delivery_persons');

		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('rider_earning');
	}

}
