<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryPersonAssignmentsTable extends Migration {
	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('delivery_person_assignments', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->unsignedBigInteger('order_id');
			$table->unsignedBigInteger('delivery_person_id');
			$table->string('latitude')->comment('current_lat');
			$table->string('longitude')->comment('current_long');
			$table->string('reason');
			$table->boolean('status')->default(1)->comment('1=>Assign,2=>Accept,3=>Reject');
			$table->timestamps();

			$table->foreign('order_id')->references('id')->on('orders');
			$table->foreign('delivery_person_id')->references('id')->on('delivery_persons');
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('delivery_person_assignments');
	}

}
