<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('payments', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->unsignedBigInteger('order_id');
			$table->double('amount');
			$table->unsignedBigInteger('paid_by')->comment('name of person who paid the transactions');
			$table->date('payment_date');
			$table->unsignedBigInteger('processed_by')->comment('this is a foreign key that connects or links to the user table');
			$table->timestamps();

			$table->foreign('paid_by')->references('id')->on('users');
			
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('payments');
	}

}
